/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.wrappers.DatabaseTableWrapper;

public class MongoDatabaseTableWrapper
implements DatabaseTableWrapper {
    private final MongoCollection<Document> collection;

    public MongoDatabaseTableWrapper(MongoDatabase database, String name) {
        this.collection = database.getCollection(name);
    }

    public void insert(@NotNull String key, @NotNull String id, @NotNull JsonConfiguration data) {
        this.update(key, id, data);
    }

    public void update(@NotNull String key, @NotNull String id, @NotNull JsonConfiguration newData) {
        Optional<JsonConfiguration> configuration = this.get(key, id);
        newData.add("_key", key).add("_identifier", id);
        if (configuration.isPresent()) {
            this.collection.updateOne(Filters.eq((String)"_key", (Object)key), (Bson)new JsonConfiguration().getGson().fromJson(newData.toPrettyString(), Document.class));
        } else {
            this.collection.insertOne(new JsonConfiguration().getGson().fromJson(newData.toPrettyString(), Document.class));
        }
    }

    public void remove(@NotNull String key, @NotNull String id) {
        if (this.collection.deleteOne(Filters.eq((String)"_key", (Object)key)).getDeletedCount() > 0L) {
            return;
        }
        this.collection.deleteOne(Filters.eq((String)"_identifier", (Object)id));
    }

    @NotNull
    public Optional<JsonConfiguration> get(@NotNull String key, @NotNull String id) {
        Optional<JsonConfiguration> configuration = this.find("_key", key);
        return configuration.isPresent() ? configuration : this.find("_identifier", id);
    }

    @NotNull
    public @UnmodifiableView Collection<String> getEntryNames() {
        ArrayList<String> collection = new ArrayList<String>();
        this.collection.find().forEach(e -> collection.add(e.getString((Object)"_key")));
        return collection;
    }

    public long count() {
        return this.collection.countDocuments();
    }

    public void clear() {
        this.collection.drop();
    }

    @NotNull
    public @UnmodifiableView Collection<JsonConfiguration> getAll() {
        ArrayList<JsonConfiguration> collection = new ArrayList<JsonConfiguration>();
        this.collection.find().forEach(e -> collection.add(new JsonConfiguration(e.toJson())));
        return collection;
    }

    public boolean has(@NotNull String key) {
        return this.find("_key", key).isPresent();
    }

    private Optional<JsonConfiguration> find(String keyName, String expected) {
        Document document = (Document)this.collection.find(Filters.eq((String)keyName, (Object)expected)).first();
        if (document == null) {
            return Optional.empty();
        }
        JsonConfiguration configuration = new JsonConfiguration(document.toJson());
        configuration.remove("_key").remove("_identifier");
        return Optional.of(configuration);
    }
}

