/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.provider.DatabaseProvider;
import systems.reformcloud.reformcloud2.executor.api.wrappers.DatabaseTableWrapper;
import systems.reformcloud.reformcloud2.mongo.MongoDatabaseTableWrapper;
import systems.reformcloud.reformcloud2.mongo.config.MongoConfig;

public class MongoDatabaseProvider
implements DatabaseProvider,
AutoCloseable {
    private final MongoClient client;
    private final MongoDatabase database;

    public MongoDatabaseProvider(MongoConfig config) {
        try {
            this.client = MongoClients.create((String)MessageFormat.format("mongodb://{0}:{1}@{2}:{3}/{4}", config.getUserName(), URLEncoder.encode(config.getPassword(), StandardCharsets.UTF_8.name()), config.getHost(), Integer.toString(config.getPort()), config.getDatabase()));
            this.database = this.client.getDatabase(config.getDatabase());
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    @NotNull
    public DatabaseTableWrapper createTable(@NotNull String tableName) {
        return new MongoDatabaseTableWrapper(this.database, tableName);
    }

    public void deleteTable(@NotNull String tableName) {
        this.database.getCollection(tableName).drop();
    }

    @NotNull
    public @UnmodifiableView Collection<String> getTableNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.client.listDatabaseNames()) {
            result.add(s);
        }
        return result;
    }

    @NotNull
    public DatabaseTableWrapper getDatabase(@NotNull String tableName) {
        return new MongoDatabaseTableWrapper(this.database, tableName);
    }

    @Override
    public void close() {
        this.client.close();
    }
}

