/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.mongo;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.base.Conditions;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.dependency.util.DependencyParser;
import systems.reformcloud.reformcloud2.executor.api.provider.DatabaseProvider;
import systems.reformcloud.reformcloud2.mongo.MongoDatabaseProvider;
import systems.reformcloud.reformcloud2.mongo.config.MongoConfig;

public class MongoApplication
extends Application {
    private DatabaseProvider before;

    public void onLoad() {
        MongoConfig config;
        DependencyParser.getAllDependencies((String)"dependencies.txt", new HashMap(), (ClassLoader)MongoApplication.class.getClassLoader()).forEach(e -> {
            URL dependencyURL = this.getDependencyLoader().loadDependency(e);
            Conditions.nonNull((Object)dependencyURL, (Object)("Dependency load for " + e.getArtifactID() + " failed"));
            this.getDependencyLoader().addDependency(dependencyURL);
        });
        Path configPath = this.getDataFolder().toPath().resolve("config.json");
        if (Files.notExists(configPath, new LinkOption[0])) {
            new JsonConfiguration().add("config", (Object)new MongoConfig("127.0.0.1", 3306, "cloud", "cloud", "")).write(configPath);
        }
        if ((config = (MongoConfig)JsonConfiguration.read((Path)configPath).get("config", MongoConfig.class)) == null) {
            System.err.println("Unable to load configuration for mongo module");
            return;
        }
        this.before = ExecutorAPI.getInstance().getDatabaseProvider();
        ExecutorAPI.getInstance().getServiceRegistry().setProvider(DatabaseProvider.class, (Object)new MongoDatabaseProvider(config), false, true);
    }

    public void onDisable() {
        DatabaseProvider providerUnchecked = (DatabaseProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(DatabaseProvider.class);
        if (providerUnchecked instanceof MongoDatabaseProvider) {
            ((MongoDatabaseProvider)providerUnchecked).close();
            ExecutorAPI.getInstance().getServiceRegistry().setProvider(DatabaseProvider.class, (Object)this.before, false, true);
        }
    }
}

