/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.file;

import de.derklaro.projects.deer.api.Database;
import de.derklaro.projects.deer.api.basic.Filters;
import de.derklaro.projects.deer.api.provider.DatabaseProvider;
import de.derklaro.projects.deer.api.writer.FileWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.io.IOUtils;
import systems.reformcloud.reformcloud2.executor.api.wrappers.DatabaseTableWrapper;
import systems.reformcloud.reformcloud2.file.SerializableJsonConfiguration;

public class FileDatabaseTableWrapper
implements DatabaseTableWrapper {
    private final Database<SerializableJsonConfiguration> database;

    public FileDatabaseTableWrapper(@NotNull String tableName) {
        this.database = DatabaseProvider.getDatabaseDriver().getDatabase(new File("reformcloud/.database", tableName), SerializableJsonConfiguration::new, 1);
    }

    public void insert(@NotNull String key, @NotNull String id, @NotNull JsonConfiguration data) {
        Optional<SerializableJsonConfiguration> entry = this.getEntry(key, id);
        if (entry.isPresent()) {
            this.database.updateKey(Filters.keyEq((String)key), (FileWriter)new SerializableJsonConfiguration(data));
        } else {
            this.database.insert(key, new String[]{id}, (FileWriter)new SerializableJsonConfiguration(data));
        }
    }

    public void update(@NotNull String key, @NotNull String id, @NotNull JsonConfiguration newData) {
        Optional<SerializableJsonConfiguration> entry = this.getEntry(key, id);
        if (entry.isPresent()) {
            this.database.updateKey(Filters.keyEq((String)key), (FileWriter)new SerializableJsonConfiguration(newData));
        } else {
            this.database.insert(key, new String[]{id}, (FileWriter)new SerializableJsonConfiguration(newData));
        }
    }

    public void remove(@NotNull String key, @NotNull String id) {
        this.database.delete(Filters.keyEq((String)key));
        this.database.delete(Filters.anyValueMatch((String)id));
    }

    @NotNull
    public Optional<JsonConfiguration> get(@NotNull String key, @NotNull String id) {
        return this.getEntry(key, id).map(result -> new JsonConfiguration(result.getJsonObject()));
    }

    @NotNull
    public @UnmodifiableView Collection<String> getEntryNames() {
        ArrayList<String> collection = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.database.getTargetFolder().toPath());){
            for (Path path : stream) {
                if (path.toString().endsWith(".properties")) continue;
                String fileName = path.getFileName().toString();
                collection.add(fileName.split("-")[0]);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return collection;
    }

    public long count() {
        AtomicLong atomicLong = new AtomicLong();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.database.getTargetFolder().toPath());){
            for (Path path : stream) {
                if (path.toString().endsWith(".properties")) continue;
                atomicLong.addAndGet(1L);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return atomicLong.get();
    }

    public void clear() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.database.getTargetFolder().toPath());){
            for (Path path : stream) {
                if (path.toString().endsWith(".properties")) continue;
                IOUtils.deleteFile((Path)path);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @NotNull
    public @UnmodifiableView Collection<JsonConfiguration> getAll() {
        ArrayList<JsonConfiguration> collection = new ArrayList<JsonConfiguration>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.database.getTargetFolder().toPath());){
            for (Path path : stream) {
                if (path.toString().endsWith(".properties")) continue;
                collection.add(JsonConfiguration.read((Path)path));
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return collection;
    }

    public boolean has(@NotNull String key) {
        return this.database.getEntry(Filters.keyEq((String)key)).isPresent();
    }

    private Optional<SerializableJsonConfiguration> getEntry(String key, String id) {
        Optional entry = this.database.getEntry(Filters.keyEq((String)key));
        return entry.isPresent() ? entry : this.database.getEntry(Filters.anyValueMatch((String)id));
    }
}

