/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.io.IOUtils;
import systems.reformcloud.reformcloud2.executor.api.provider.DatabaseProvider;
import systems.reformcloud.reformcloud2.executor.api.wrappers.DatabaseTableWrapper;
import systems.reformcloud.reformcloud2.file.FileDatabaseTableWrapper;

public class FileDatabaseProvider
implements DatabaseProvider {
    public FileDatabaseProvider() {
        try {
            Class.forName("de.derklaro.projects.deer.executor.BasicDatabaseDriver");
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    @NotNull
    public DatabaseTableWrapper createTable(@NotNull String tableName) {
        return new FileDatabaseTableWrapper(tableName);
    }

    public void deleteTable(@NotNull String tableName) {
        IOUtils.deleteDirectory((Path)Paths.get("reformcloud/.database", tableName));
    }

    @NotNull
    public @UnmodifiableView Collection<String> getTableNames() {
        ArrayList<String> collection = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get("reformcloud/.database", new String[0]));){
            for (Path path : stream) {
                collection.add(path.getFileName().toString());
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return collection;
    }

    @NotNull
    public DatabaseTableWrapper getDatabase(@NotNull String tableName) {
        return new FileDatabaseTableWrapper(tableName);
    }
}

