/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import systems.reformcloud.reformcloud2.commands.application.packet.PacketGetCommandsConfig;
import systems.reformcloud.reformcloud2.commands.application.packet.PacketGetCommandsConfigResult;
import systems.reformcloud.reformcloud2.commands.plugin.CommandConfigHandler;
import systems.reformcloud.reformcloud2.commands.plugin.packet.PacketReleaseCommandsConfig;
import systems.reformcloud.reformcloud2.commands.plugin.velocity.handler.VelocityCommandConfigHandler;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.network.NetworkUtil;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.PacketSender;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;

@Plugin(id="reformcloud_2_commands", name="ReformCloud2Commands", version="2.0", description="Get access to default reformcloud2 commands", url="https://reformcloud.systems", authors={"derklaro"}, dependencies={@Dependency(id="reformcloud_2_api_executor")})
public class VelocityPlugin {
    @Inject
    public VelocityPlugin(ProxyServer proxyServer) {
        CommandConfigHandler.setInstance(new VelocityCommandConfigHandler(proxyServer));
        NetworkUtil.EXECUTOR.execute(() -> {
            PacketSender sender = (PacketSender)DefaultChannelManager.INSTANCE.get("Controller").orNothing();
            while (sender == null) {
                sender = (PacketSender)DefaultChannelManager.INSTANCE.get("Controller").orNothing();
            }
            ExecutorAPI.getInstance().getPacketHandler().registerHandler(PacketGetCommandsConfigResult.class);
            ExecutorAPI.getInstance().getPacketHandler().getQueryHandler().sendQueryAsync(sender, (Packet)new PacketGetCommandsConfig()).onComplete(e -> {
                if (e instanceof PacketGetCommandsConfigResult) {
                    CommandConfigHandler.getInstance().handleCommandConfigRelease(((PacketGetCommandsConfigResult)((Object)((Object)e))).getCommandsConfig());
                    ExecutorAPI.getInstance().getPacketHandler().registerHandler(PacketReleaseCommandsConfig.class);
                }
            });
        });
    }
}

