/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.internal;

import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.CommonHelper;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;

public final class InternalReformCloudCommand {
    private static final String PROCESS_DISPLAY_FORMAT = " * \u00a77%s \u00a78| \u00a77%s \u00a78| \u00a77%d\u00a78/\u00a77%d \u00a78| %s";

    private InternalReformCloudCommand() {
        throw new UnsupportedOperationException();
    }

    public static void execute(@NotNull Consumer<String> messageSender, @NotNull String[] strings, @NotNull String prefix, @NotNull String commandSuccessMessage, @NotNull String anyAlias) {
        StringBuilder stringBuilder;
        if (strings.length == 1 && strings[0].equalsIgnoreCase("list")) {
            ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().getAllProcessesAsync().onComplete(processes -> {
                for (ProcessInformation process : processes) {
                    String state = "\u00a7coffline";
                    if (process.getProcessDetail().getProcessState().isValid() && !process.getNetworkInfo().isConnected()) {
                        state = "\u00a7econnecting";
                    } else if (process.getProcessDetail().getProcessState().isReady()) {
                        state = "\u00a7aonline";
                    }
                    messageSender.accept(String.format(PROCESS_DISPLAY_FORMAT, process.getProcessDetail().getName(), process.getProcessDetail().getParentName(), process.getProcessPlayerManager().getOnlineCount(), process.getProcessDetail().getMaxPlayers(), state));
                }
            });
            return;
        }
        if (strings.length == 2) {
            switch (strings[0].toLowerCase()) {
                case "copy": {
                    ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().getProcessAsync(strings[1]).onComplete(process -> {
                        if (process == null) {
                            messageSender.accept(prefix + "\u00a7cThis process is unknown");
                            return;
                        }
                        process.toWrapped().copy();
                    });
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
                case "start": {
                    ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().startProcessAsync(strings[1]);
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
                case "stop": {
                    ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().stopProcessAsync(strings[1]);
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
                case "stopall": {
                    ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().getProcessesAsync(strings[1]).onComplete(results -> {
                        for (ProcessInformation result : results) {
                            ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().stopProcessAsync(result);
                        }
                    });
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
                case "maintenance": {
                    ExecutorAPI.getInstance().getAsyncAPI().getGroupAsyncAPI().getProcessGroupAsync(strings[1]).onComplete(processGroup -> {
                        if (processGroup == null) {
                            messageSender.accept(prefix + "\u00a7cThis group is unknown");
                            return;
                        }
                        processGroup.getPlayerAccessConfiguration().toggleMaintenance();
                        ExecutorAPI.getInstance().getSyncAPI().getGroupSyncAPI().updateProcessGroup(processGroup);
                    });
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
            }
        }
        if (strings.length == 3) {
            switch (strings[0].toLowerCase()) {
                case "start": {
                    Integer count = CommonHelper.fromString((String)strings[2]);
                    if (count == null || count <= 0) {
                        messageSender.accept(prefix + "\u00a7cPlease provide a valid count!");
                        return;
                    }
                    Task.EXECUTOR.execute(() -> {
                        for (int started = 1; started <= count; ++started) {
                            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().startProcess(strings[1]);
                        }
                    });
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
                case "ofall": {
                    if (!strings[2].equalsIgnoreCase("stop")) break;
                    ExecutorAPI.getInstance().getAsyncAPI().getGroupAsyncAPI().getMainGroupAsync(strings[1]).onComplete(mainGroup -> {
                        if (mainGroup == null) {
                            messageSender.accept(prefix + "\u00a7cThis main group is unknown");
                            return;
                        }
                        for (String subGroup : mainGroup.getSubGroups()) {
                            ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().getProcessesAsync(subGroup).onComplete(processes -> {
                                for (ProcessInformation process : processes) {
                                    ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().stopProcessAsync(process);
                                }
                            });
                        }
                    });
                    messageSender.accept(commandSuccessMessage);
                    return;
                }
            }
        }
        if (strings.length >= 3 && strings[0].equalsIgnoreCase("execute")) {
            stringBuilder = new StringBuilder();
            for (String s : Arrays.copyOfRange(strings, 2, strings.length)) {
                stringBuilder.append(s).append(" ");
            }
            ExecutorAPI.getInstance().getAsyncAPI().getProcessAsyncAPI().executeProcessCommandAsync(strings[1], stringBuilder.toString());
            messageSender.accept(commandSuccessMessage);
            return;
        }
        if (strings.length >= 2 && strings[0].equalsIgnoreCase("cmd")) {
            stringBuilder = new StringBuilder();
            for (String s : Arrays.copyOfRange(strings, 1, strings.length)) {
                stringBuilder.append(s).append(" ");
            }
            ExecutorAPI.getInstance().getAsyncAPI().getConsoleAsyncAPI().dispatchConsoleCommandAndGetResultAsync(stringBuilder.toString()).onComplete(messages -> {
                for (String message : messages) {
                    messageSender.accept("\u00a77" + message);
                }
            });
            messageSender.accept(commandSuccessMessage);
            return;
        }
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " list");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " copy <name>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " start <group>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " start <group> <amount>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " stop <name>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " stopall <group>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " ofall <mainGroup> stop");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " execute <name> <command>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " maintenance <group>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " cmd <command>");
    }
}

