/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.bungeecord.commands;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.bungee.BungeeExecutor;
import systems.reformcloud.reformcloud2.executor.api.bungee.fallback.BungeeFallbackExtraFilter;
import systems.reformcloud.reformcloud2.executor.api.shared.SharedPlayerFallbackFilter;

public class CommandLeave
extends Command {
    public CommandLeave(@NotNull String name, @NotNull List<String> aliases) {
        super(name, null, aliases.toArray(new String[0]));
    }

    public void execute(CommandSender commandSender, String[] strings) {
        if (!(commandSender instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer proxiedPlayer = (ProxiedPlayer)commandSender;
        if (proxiedPlayer.getServer() == null) {
            return;
        }
        if (BungeeExecutor.getInstance().getCachedLobbyServices().stream().anyMatch(e -> e.getProcessDetail().getName().equals(proxiedPlayer.getServer().getInfo().getName()))) {
            proxiedPlayer.sendMessage(TextComponent.fromLegacyText((String)BungeeExecutor.getInstance().getMessages().format(BungeeExecutor.getInstance().getMessages().getAlreadyConnectedToHub(), new Object[0])));
            return;
        }
        SharedPlayerFallbackFilter.filterFallback((UUID)proxiedPlayer.getUniqueId(), (Collection)BungeeExecutor.getInstance().getCachedLobbyServices(), arg_0 -> ((ProxiedPlayer)proxiedPlayer).hasPermission(arg_0), (Predicate)BungeeFallbackExtraFilter.INSTANCE, (String)proxiedPlayer.getServer().getInfo().getName()).ifPresent(processInformation -> {
            ServerInfo serverInfo = ProxyServer.getInstance().getServerInfo(processInformation.getProcessDetail().getName());
            if (serverInfo == null) {
                proxiedPlayer.sendMessage(TextComponent.fromLegacyText((String)BungeeExecutor.getInstance().getMessages().format(BungeeExecutor.getInstance().getMessages().getNoHubServerAvailable(), new Object[0])));
                return;
            }
            proxiedPlayer.sendMessage(TextComponent.fromLegacyText((String)BungeeExecutor.getInstance().getMessages().format(BungeeExecutor.getInstance().getMessages().getConnectingToHub(), new Object[]{processInformation.getProcessDetail().getName()})));
            proxiedPlayer.connect(serverInfo);
        }).ifEmpty(v -> proxiedPlayer.sendMessage(TextComponent.fromLegacyText((String)BungeeExecutor.getInstance().getMessages().format(BungeeExecutor.getInstance().getMessages().getNoHubServerAvailable(), new Object[0]))));
    }
}

