/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.velocity.commands;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.CommonHelper;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.groups.MainGroup;
import systems.reformcloud.reformcloud2.executor.api.common.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.thread.AbsoluteThread;
import systems.reformcloud.reformcloud2.executor.api.velocity.VelocityExecutor;

public class CommandReformCloud
implements Command {
    private final List<String> aliases;

    public CommandReformCloud(@NotNull List<String> aliases) {
        this.aliases = aliases;
    }

    public void execute(CommandSource commandSender, @NotNull String[] strings) {
        StringBuilder stringBuilder;
        String prefix = VelocityExecutor.getInstance().getMessages().getPrefix() + " ";
        if (strings.length == 1 && strings[0].equalsIgnoreCase("list")) {
            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().forEach(e -> commandSender.sendMessage((Component)TextComponent.of((String)("=> " + e.getProcessDetail().getName() + "/ Display: " + e.getProcessDetail().getDisplayName() + "/ UniqueID: " + e.getProcessDetail().getProcessUniqueID() + "/ Parent: " + e.getProcessDetail().getParentName() + "/ Connected: " + e.getNetworkInfo().isConnected()))));
            return;
        }
        if (strings.length == 2) {
            switch (strings[0].toLowerCase()) {
                case "copy": {
                    ProcessInformation process = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getProcess(strings[1]);
                    if (process == null) {
                        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a7cThis process is unknown")));
                        return;
                    }
                    process.toWrapped().copy();
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
                case "start": {
                    ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().startProcess(strings[1]);
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
                case "stop": {
                    ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().stopProcess(strings[1]);
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
                case "stopall": {
                    ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getProcesses(strings[1]).forEach(e -> ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().stopProcess(e.getProcessDetail().getName()));
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
                case "maintenance": {
                    ProcessGroup processGroup = ExecutorAPI.getInstance().getSyncAPI().getGroupSyncAPI().getProcessGroup(strings[1]);
                    if (processGroup == null) {
                        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a7cThis group is unknown")));
                        return;
                    }
                    processGroup.getPlayerAccessConfiguration().toggleMaintenance();
                    ExecutorAPI.getInstance().getSyncAPI().getGroupSyncAPI().updateProcessGroup(processGroup);
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
            }
        }
        if (strings.length == 3) {
            switch (strings[0].toLowerCase()) {
                case "start": {
                    Integer count = CommonHelper.fromString((String)strings[2]);
                    if (count == null || count <= 0) {
                        count = 1;
                    }
                    if (count == 1) {
                        ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().startProcess(strings[1]);
                    } else {
                        for (int started = 1; started <= count; ++started) {
                            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().startProcess(strings[1]);
                            AbsoluteThread.sleep((TimeUnit)TimeUnit.MILLISECONDS, (long)20L);
                        }
                    }
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
                case "ofall": {
                    if (!strings[2].equalsIgnoreCase("stop")) break;
                    MainGroup mainGroup = ExecutorAPI.getInstance().getSyncAPI().getGroupSyncAPI().getMainGroup(strings[1]);
                    if (mainGroup == null) {
                        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a7cThis main group is unknown")));
                        return;
                    }
                    mainGroup.getSubGroups().forEach(s -> {
                        ProcessGroup processGroup = ExecutorAPI.getInstance().getSyncAPI().getGroupSyncAPI().getProcessGroup(s);
                        if (processGroup == null) {
                            return;
                        }
                        ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getProcesses(processGroup.getName()).forEach(processInformation -> {
                            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().stopProcess(processInformation.getProcessDetail().getProcessUniqueID());
                            AbsoluteThread.sleep((TimeUnit)TimeUnit.MILLISECONDS, (long)10L);
                        });
                    });
                    commandSender.sendMessage((Component)this.getCommandSuccessMessage());
                    return;
                }
            }
        }
        if (strings.length >= 3 && strings[0].equalsIgnoreCase("execute")) {
            stringBuilder = new StringBuilder();
            for (String s2 : Arrays.copyOfRange(strings, 2, strings.length)) {
                stringBuilder.append(s2).append(" ");
            }
            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().executeProcessCommand(strings[1], stringBuilder.toString());
            commandSender.sendMessage((Component)this.getCommandSuccessMessage());
            return;
        }
        if (strings.length >= 2 && strings[0].equalsIgnoreCase("cmd")) {
            stringBuilder = new StringBuilder();
            for (String s3 : Arrays.copyOfRange(strings, 1, strings.length)) {
                stringBuilder.append(s3).append(" ");
            }
            ExecutorAPI.getInstance().getSyncAPI().getConsoleSyncAPI().dispatchCommandAndGetResult(stringBuilder.toString());
            commandSender.sendMessage((Component)this.getCommandSuccessMessage());
            return;
        }
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc list")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc copy <name>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc start <group>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc start <group> <count>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc stop <name>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc stopall <group>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc ofall <mainGroup> stop")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc execute <name> <command>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc maintenance <group>")));
        commandSender.sendMessage((Component)TextComponent.of((String)(prefix + "\u00a77/rc cmd <command>")));
    }

    private TextComponent getCommandSuccessMessage() {
        String message = VelocityExecutor.getInstance().getMessages().getCommandExecuteSuccess();
        message = VelocityExecutor.getInstance().getMessages().format(message, new Object[0]);
        return TextComponent.of((String)message);
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean hasPermission(CommandSource source, @NotNull String[] args) {
        return source.hasPermission("reformcloud.command.reformcloud");
    }
}

