/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.application;

import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.commands.application.listener.ProcessInclusionHandler;
import systems.reformcloud.reformcloud2.commands.application.packet.in.PacketInGetCommandsConfig;
import systems.reformcloud.reformcloud2.commands.application.packet.out.PacketOutReleaseCommandsConfig;
import systems.reformcloud.reformcloud2.commands.application.update.CommandAddonUpdater;
import systems.reformcloud.reformcloud2.commands.config.CommandsConfig;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.ApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.handler.NetworkHandler;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;

public class ReformCloudApplication
extends Application {
    private static ReformCloudApplication instance;
    private static CommandsConfig commandsConfig;
    private static final ApplicationUpdateRepository REPOSITORY;

    public void onInstallable() {
        ExecutorAPI.getInstance().getEventManager().registerListener((Object)new ProcessInclusionHandler());
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        Path path = Paths.get(this.dataFolder().getPath(), "config.json");
        if (!Files.exists(path, new LinkOption[0])) {
            SystemHelper.createDirectory((Path)this.dataFolder().toPath());
            new JsonConfiguration().add("config", (Object)new CommandsConfig(true, Arrays.asList("l", "leave", "lobby", "hub", "quit"), true, Arrays.asList("reformcloud", "rc", "cloud"))).write(path);
        }
        commandsConfig = (CommandsConfig)JsonConfiguration.read((Path)path).get("config", (TypeToken)new TypeToken<CommandsConfig>(){});
        ExecutorAPI.getInstance().getPacketHandler().registerHandler((NetworkHandler)new PacketInGetCommandsConfig());
        DefaultChannelManager.INSTANCE.getAllSender().forEach(e -> e.sendPacket((Packet)new PacketOutReleaseCommandsConfig(commandsConfig)));
    }

    public void onPreDisable() {
        ExecutorAPI.getInstance().getPacketHandler().unregisterNetworkHandlers(50001);
    }

    @Nullable
    public ApplicationUpdateRepository getUpdateRepository() {
        return REPOSITORY;
    }

    public static CommandsConfig getCommandsConfig() {
        return commandsConfig;
    }

    public static ReformCloudApplication getInstance() {
        return instance;
    }

    static {
        REPOSITORY = new CommandAddonUpdater();
    }
}

