/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.velocity.handler;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.proxy.ProxyServer;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.commands.config.CommandsConfig;
import systems.reformcloud.reformcloud2.commands.plugin.CommandConfigHandler;
import systems.reformcloud.reformcloud2.commands.plugin.velocity.commands.CommandLeave;
import systems.reformcloud.reformcloud2.commands.plugin.velocity.commands.CommandReformCloud;

public class VelocityCommandConfigHandler
extends CommandConfigHandler {
    private final ProxyServer proxyServer;
    private CommandLeave commandLeave;
    private CommandReformCloud commandReformCloud;

    public VelocityCommandConfigHandler(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    @Override
    public void handleCommandConfigRelease(@NotNull CommandsConfig commandsConfig) {
        this.unregisterAllCommands();
        if (commandsConfig.isLeaveCommandEnabled() && commandsConfig.getLeaveCommands().size() > 0) {
            this.commandLeave = new CommandLeave(commandsConfig.getLeaveCommands());
            this.proxyServer.getCommandManager().register((Command)this.commandLeave, commandsConfig.getLeaveCommands().toArray(new String[0]));
        }
        if (commandsConfig.isReformCloudCommandEnabled() && commandsConfig.getReformCloudCommands().size() > 0) {
            this.commandReformCloud = new CommandReformCloud(commandsConfig.getReformCloudCommands());
            this.proxyServer.getCommandManager().register((Command)this.commandReformCloud, commandsConfig.getReformCloudCommands().toArray(new String[0]));
        }
    }

    @Override
    public void unregisterAllCommands() {
        if (this.commandLeave != null) {
            this.commandLeave.getAliases().forEach(arg_0 -> ((CommandManager)this.proxyServer.getCommandManager()).unregister(arg_0));
            this.commandLeave = null;
        }
        if (this.commandReformCloud != null) {
            this.commandReformCloud.getAliases().forEach(arg_0 -> ((CommandManager)this.proxyServer.getCommandManager()).unregister(arg_0));
            this.commandReformCloud = null;
        }
    }
}

