/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import systems.refomcloud.reformcloud2.embedded.Embedded;
import systems.reformcloud.reformcloud2.commands.application.packet.PacketGetCommandsConfig;
import systems.reformcloud.reformcloud2.commands.application.packet.PacketGetCommandsConfigResult;
import systems.reformcloud.reformcloud2.commands.plugin.CommandConfigHandler;
import systems.reformcloud.reformcloud2.commands.plugin.packet.PacketReleaseCommandsConfig;
import systems.reformcloud.reformcloud2.commands.plugin.velocity.handler.VelocityCommandConfigHandler;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.network.packet.PacketProvider;

@Plugin(id="reformcloud_2_commands", name="ReformCloud2Commands", version="2.0", description="Get access to default reformcloud2 commands", url="https://reformcloud.systems", authors={"derklaro"}, dependencies={@Dependency(id="reformcloud_2_api_executor")})
public class VelocityPlugin {
    private final ProxyServer proxyServer;

    @Inject
    public VelocityPlugin(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    @Subscribe
    public void handle(ProxyInitializeEvent event) {
        CommandConfigHandler.setInstance(new VelocityCommandConfigHandler(this.proxyServer));
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).registerPacket(PacketGetCommandsConfigResult.class);
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).registerPacket(PacketReleaseCommandsConfig.class);
        Embedded.getInstance().sendSyncQuery((Packet)new PacketGetCommandsConfig()).ifPresent(e -> {
            if (e instanceof PacketGetCommandsConfigResult) {
                CommandConfigHandler.getInstance().handleCommandConfigRelease(((PacketGetCommandsConfigResult)((Object)e)).getCommandsConfig());
            }
        });
    }

    @Subscribe
    public void handle(ProxyShutdownEvent event) {
        CommandConfigHandler.getInstance().unregisterAllCommands();
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).unregisterPacket(6003);
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).unregisterPacket(6002);
    }
}

