/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.internal;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import systems.refomcloud.reformcloud2.embedded.Embedded;
import systems.reformcloud.reformcloud2.executor.api.CommonHelper;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.network.channel.manager.ChannelManager;
import systems.reformcloud.reformcloud2.executor.api.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.process.ProcessState;
import systems.reformcloud.reformcloud2.executor.api.wrappers.NodeProcessWrapper;
import systems.reformcloud.reformcloud2.executor.api.wrappers.ProcessWrapper;

public final class InternalReformCloudCommand {
    private static final String PROCESS_DISPLAY_FORMAT = " * \u00a77%s \u00a78| \u00a77%s \u00a78| \u00a77%d\u00a78/\u00a77%d \u00a78| %s";

    private InternalReformCloudCommand() {
        throw new UnsupportedOperationException();
    }

    public static void execute(@NotNull Consumer<String> messageSender, @NotNull String[] strings, @NotNull String prefix, @NotNull String commandSuccessMessage, @NotNull String anyAlias) {
        StringBuilder stringBuilder;
        if (strings.length == 1 && strings[0].equalsIgnoreCase("list")) {
            ExecutorAPI.getInstance().getProcessProvider().getProcessesAsync().onComplete(processes -> {
                for (ProcessInformation process : processes) {
                    String state = "\u00a7coffline";
                    if (process.getProcessDetail().getProcessState().isStartedOrOnline() && !process.getNetworkInfo().isConnected()) {
                        state = "\u00a7econnecting";
                    } else if (process.getProcessDetail().getProcessState().isOnline()) {
                        state = "\u00a7aonline";
                    }
                    messageSender.accept(String.format(PROCESS_DISPLAY_FORMAT, process.getProcessDetail().getName(), process.getProcessDetail().getParentName(), process.getProcessPlayerManager().getOnlineCount(), process.getProcessDetail().getMaxPlayers(), state));
                }
            });
            return;
        }
        if (strings.length == 2) {
            switch (strings[0].toLowerCase()) {
                case "copy": {
                    ExecutorAPI.getInstance().getProcessProvider().getProcessByNameAsync(strings[1]).onComplete(process -> {
                        if (!process.isPresent()) {
                            messageSender.accept(prefix + "\u00a7cThis process is unknown");
                            return;
                        }
                        ProcessWrapper wrapper = (ProcessWrapper)process.get();
                        wrapper.copy(wrapper.getProcessInformation().getProcessDetail().getTemplate());
                        messageSender.accept(commandSuccessMessage);
                    });
                    return;
                }
                case "start": {
                    ExecutorAPI.getInstance().getProcessGroupProvider().getProcessGroupAsync(strings[1]).thenAccept(processGroup -> {
                        if (!processGroup.isPresent()) {
                            messageSender.accept(prefix + "\u00a7cThe specified group is unknown");
                            return;
                        }
                        ExecutorAPI.getInstance().getProcessProvider().createProcess().group(strings[1]).prepare().onComplete(processWrapper -> processWrapper.setRuntimeState(ProcessState.STARTED));
                        messageSender.accept(commandSuccessMessage);
                    });
                    return;
                }
                case "stop": {
                    ExecutorAPI.getInstance().getProcessProvider().getProcessByNameAsync(strings[1]).onComplete(processWrapper -> {
                        if (!processWrapper.isPresent()) {
                            messageSender.accept(prefix + "\u00a7cThis process is unknown");
                            return;
                        }
                        ((ProcessWrapper)processWrapper.get()).setRuntimeState(ProcessState.STOPPED);
                        messageSender.accept(commandSuccessMessage);
                    });
                    return;
                }
                case "maintenance": {
                    ExecutorAPI.getInstance().getProcessGroupProvider().getProcessGroupAsync(strings[1]).onComplete(processGroup -> {
                        if (!processGroup.isPresent()) {
                            messageSender.accept(prefix + "\u00a7cThe specified group is unknown");
                            return;
                        }
                        ((ProcessGroup)processGroup.get()).getPlayerAccessConfiguration().toggleMaintenance();
                        ExecutorAPI.getInstance().getProcessGroupProvider().updateProcessGroup((ProcessGroup)processGroup.get());
                        messageSender.accept(commandSuccessMessage);
                    });
                    return;
                }
            }
        }
        if (strings.length == 3 && "start".equals(strings[0].toLowerCase())) {
            Integer count = CommonHelper.fromString((String)strings[2]);
            if (count == null || count <= 0) {
                messageSender.accept(prefix + "\u00a7cPlease provide a valid count!");
                return;
            }
            for (int started = 1; started <= count; ++started) {
                ExecutorAPI.getInstance().getProcessProvider().createProcess().group(strings[1]).prepare().onComplete(wrapper -> wrapper.setRuntimeState(ProcessState.STARTED));
            }
            messageSender.accept(commandSuccessMessage);
            return;
        }
        if (strings.length >= 3 && strings[0].equalsIgnoreCase("execute")) {
            stringBuilder = new StringBuilder();
            for (String s : Arrays.copyOfRange(strings, 2, strings.length)) {
                stringBuilder.append(s).append(" ");
            }
            ExecutorAPI.getInstance().getProcessProvider().getProcessByNameAsync(strings[1]).onComplete(processWrapper -> {
                if (!processWrapper.isPresent()) {
                    messageSender.accept(prefix + "\u00a7cThis process is unknown");
                    return;
                }
                ((ProcessWrapper)processWrapper.get()).sendCommand(stringBuilder.toString());
                messageSender.accept(commandSuccessMessage);
            });
            return;
        }
        if (strings.length >= 2 && strings[0].equalsIgnoreCase("cmd")) {
            stringBuilder = new StringBuilder();
            for (String s : Arrays.copyOfRange(strings, 1, strings.length)) {
                stringBuilder.append(s).append(" ");
            }
            Optional channel = ((ChannelManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(ChannelManager.class)).getFirstChannel();
            if (!channel.isPresent()) {
                messageSender.accept(prefix + "\u00a7cThe target node is not connected");
                return;
            }
            ExecutorAPI.getInstance().getNodeInformationProvider().getNodeInformationAsync(Embedded.getInstance().getCurrentProcessInformation().getProcessDetail().getParentUniqueID()).onComplete(nodeProcessWrapper -> {
                if (!nodeProcessWrapper.isPresent()) {
                    messageSender.accept(prefix + "\u00a7cAn internal error occurred");
                    return;
                }
                ((NodeProcessWrapper)nodeProcessWrapper.get()).sendCommandLineAsync(stringBuilder.toString()).onComplete(result -> {
                    for (String s : result) {
                        messageSender.accept("\u00a77" + s);
                    }
                });
                messageSender.accept(commandSuccessMessage);
            });
            return;
        }
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " list");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " copy <name>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " start <group>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " start <group> <amount>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " stop <name>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " execute <name> <command>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " maintenance <group>");
        messageSender.accept(prefix + "\u00a77/" + anyAlias + " cmd <command>");
    }
}

