/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.application;

import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.commands.application.listener.ProcessInclusionHandler;
import systems.reformcloud.reformcloud2.commands.application.packet.PacketGetCommandsConfig;
import systems.reformcloud.reformcloud2.commands.application.update.CommandAddonUpdater;
import systems.reformcloud.reformcloud2.commands.config.CommandsConfig;
import systems.reformcloud.reformcloud2.commands.plugin.packet.PacketReleaseCommandsConfig;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.application.updater.ApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.event.EventManager;
import systems.reformcloud.reformcloud2.executor.api.io.IOUtils;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.channel.manager.ChannelManager;
import systems.reformcloud.reformcloud2.executor.api.network.packet.PacketProvider;

public class ReformCloudApplication
extends Application {
    private static final ApplicationUpdateRepository REPOSITORY = new CommandAddonUpdater();
    private static ReformCloudApplication instance;
    private static CommandsConfig commandsConfig;

    public static CommandsConfig getCommandsConfig() {
        return commandsConfig;
    }

    public static ReformCloudApplication getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        Path path = Paths.get(this.getDataFolder().getPath(), "config.json");
        if (!Files.exists(path, new LinkOption[0])) {
            IOUtils.createDirectory((Path)path.getParent());
            new JsonConfiguration().add("config", (Object)new CommandsConfig(true, Arrays.asList("l", "leave", "lobby", "hub", "quit"), true, Arrays.asList("reformcloud", "rc", "cloud"))).write(path);
        }
        commandsConfig = (CommandsConfig)JsonConfiguration.read((Path)path).get("config", (TypeToken)new TypeToken<CommandsConfig>(){});
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).registerPacket(PacketGetCommandsConfig.class);
        ((EventManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(EventManager.class)).registerListener((Object)new ProcessInclusionHandler());
        for (NetworkChannel registeredChannel : ((ChannelManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(ChannelManager.class)).getRegisteredChannels()) {
            if (!registeredChannel.isAuthenticated()) continue;
            registeredChannel.sendPacket((Object)new PacketReleaseCommandsConfig(commandsConfig));
        }
    }

    public void onDisable() {
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).unregisterPacket(6001);
    }

    @Nullable
    public ApplicationUpdateRepository getUpdateRepository() {
        return REPOSITORY;
    }
}

