/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.velocity.commands;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.velocity.VelocityExecutor;

public class CommandLeave
implements Command {
    private final List<String> aliases;

    public CommandLeave(@Nonnull List<String> aliases) {
        this.aliases = aliases;
    }

    public void execute(CommandSource commandSource, @NonNull String[] strings) {
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        Optional currentServer = player.getCurrentServer();
        ProcessInformation process = null;
        if (currentServer.isPresent()) {
            process = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getProcess(((ServerConnection)currentServer.get()).getServerInfo().getName());
        }
        if (!currentServer.isPresent() || process == null || process.isLobby()) {
            player.sendMessage((Component)TextComponent.of((String)VelocityExecutor.getInstance().getMessages().format(VelocityExecutor.getInstance().getMessages().getAlreadyConnectedToHub(), new Object[0])));
            return;
        }
        ProcessInformation lobby = VelocityExecutor.getBestLobbyForPlayer((ProcessInformation)API.getInstance().getCurrentProcessInformation(), (Player)player, arg_0 -> ((Player)player).hasPermission(arg_0));
        if (lobby != null) {
            player.sendMessage((Component)TextComponent.of((String)VelocityExecutor.getInstance().getMessages().format(VelocityExecutor.getInstance().getMessages().getConnectingToHub(), new Object[]{lobby.getName()})));
            VelocityExecutor.getInstance().getProxyServer().getServer(lobby.getName()).ifPresent(e -> player.createConnectionRequest(e).fireAndForget());
            return;
        }
        player.sendMessage((Component)TextComponent.of((String)VelocityExecutor.getInstance().getMessages().format(VelocityExecutor.getInstance().getMessages().getNoHubServerAvailable(), new Object[0])));
    }

    @Nonnull
    public List<String> getAliases() {
        return this.aliases;
    }
}

