/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.plugin.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import javax.annotation.Nonnull;
import systems.reformcloud.reformcloud2.commands.config.CommandsConfig;
import systems.reformcloud.reformcloud2.commands.plugin.CommandConfigHandler;
import systems.reformcloud.reformcloud2.commands.plugin.packet.in.PacketInRegisterCommandsConfig;
import systems.reformcloud.reformcloud2.commands.plugin.velocity.commands.CommandLeave;
import systems.reformcloud.reformcloud2.commands.plugin.velocity.commands.CommandReformCloud;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.handler.NetworkHandler;

@Plugin(id="reformcloud_2_commands", name="ReformCloud2Commands", version="2.0", description="Get access to default reformcloud2 commands", url="https://reformcloud.systems", authors={"derklaro"}, dependencies={@Dependency(id="reformcloud_2_api_executor")})
public class VelocityPlugin {
    private final ProxyServer proxyServer;

    @Inject
    public VelocityPlugin(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
        CommandConfigHandler.setInstance(new ConfigHandler());
        ExecutorAPI.getInstance().getPacketHandler().registerHandler((NetworkHandler)new PacketInRegisterCommandsConfig());
    }

    @Subscribe
    public void handleStop(ProxyShutdownEvent event) {
        ExecutorAPI.getInstance().getPacketHandler().unregisterNetworkHandlers(50001);
    }

    private class ConfigHandler
    extends CommandConfigHandler {
        private CommandLeave commandLeave;
        private CommandReformCloud commandReformCloud;

        private ConfigHandler() {
        }

        @Override
        public void handleCommandConfigRelease(@Nonnull CommandsConfig commandsConfig) {
            this.unregisterAllCommands();
            if (commandsConfig.isLeaveCommandEnabled() && commandsConfig.getLeaveCommands().size() > 0) {
                this.commandLeave = new CommandLeave(commandsConfig.getLeaveCommands());
                VelocityPlugin.this.proxyServer.getCommandManager().register((Command)this.commandLeave, commandsConfig.getLeaveCommands().toArray(new String[0]));
            }
            if (commandsConfig.isReformCloudCommandEnabled() && commandsConfig.getReformCloudCommands().size() > 0) {
                this.commandReformCloud = new CommandReformCloud(commandsConfig.getReformCloudCommands());
                VelocityPlugin.this.proxyServer.getCommandManager().register((Command)this.commandReformCloud, commandsConfig.getReformCloudCommands().toArray(new String[0]));
            }
        }

        @Override
        public void unregisterAllCommands() {
            if (this.commandLeave != null) {
                this.commandLeave.getAliases().forEach(arg_0 -> ((CommandManager)VelocityPlugin.this.proxyServer.getCommandManager()).unregister(arg_0));
                this.commandLeave = null;
            }
            if (this.commandReformCloud != null) {
                this.commandReformCloud.getAliases().forEach(arg_0 -> ((CommandManager)VelocityPlugin.this.proxyServer.getCommandManager()).unregister(arg_0));
                this.commandReformCloud = null;
            }
        }
    }
}

