/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.application.listener;

import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import systems.reformcloud.reformcloud2.commands.application.packet.out.PacketOutRegisterCommandsConfig;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessStoppedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessUpdatedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.event.handler.Listener;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;
import systems.reformcloud.reformcloud2.executor.api.common.utility.thread.AbsoluteThread;

public class ProcessListener {
    private final Collection<UUID> connectedProcesses = new LinkedList<UUID>();

    @Listener
    public void handle(ProcessUpdatedEvent event) {
        if (event.getProcessInformation().getNetworkInfo().isConnected() && !this.connectedProcesses.contains(event.getProcessInformation().getProcessUniqueID())) {
            this.connectedProcesses.add(event.getProcessInformation().getProcessUniqueID());
            this.waitFor(event.getProcessInformation().getName());
        }
    }

    @Listener
    public void handle(ProcessStoppedEvent event) {
        this.connectedProcesses.remove(event.getProcessInformation().getProcessUniqueID());
    }

    private void waitFor(String name) {
        Task.EXECUTOR.execute(() -> {
            while (!DefaultChannelManager.INSTANCE.get(name).isPresent()) {
                AbsoluteThread.sleep((long)20L);
            }
            AbsoluteThread.sleep((long)1000L);
            DefaultChannelManager.INSTANCE.get(name).ifPresent(e -> e.sendPacket((Packet)new PacketOutRegisterCommandsConfig()));
        });
    }
}

