/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.commands.application;

import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import systems.reformcloud.reformcloud2.commands.application.listener.ProcessListener;
import systems.reformcloud.reformcloud2.commands.application.packet.out.PacketOutRegisterCommandsConfig;
import systems.reformcloud.reformcloud2.commands.config.CommandsConfig;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;

public class ReformCloudApplication
extends Application {
    private static CommandsConfig commandsConfig;
    private static final ProcessListener LISTENER;

    public void onEnable() {
        Path path = Paths.get(this.dataFolder().getPath(), "config.json");
        if (!Files.exists(path, new LinkOption[0])) {
            SystemHelper.createDirectory((Path)this.dataFolder().toPath());
            new JsonConfiguration().add("config", (Object)new CommandsConfig(true, Arrays.asList("l", "leave", "lobby", "hub", "quit"), true, Arrays.asList("reformcloud", "rc", "cloud"))).write(path);
        }
        commandsConfig = (CommandsConfig)JsonConfiguration.read((Path)path).get("config", (TypeToken)new TypeToken<CommandsConfig>(){});
        ExecutorAPI.getInstance().getEventManager().registerListener((Object)LISTENER);
    }

    public void onPreDisable() {
        commandsConfig = new CommandsConfig(false, new ArrayList<String>(), false, new ArrayList<String>());
        ExecutorAPI.getInstance().getEventManager().unregisterListener((Object)LISTENER);
        ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().stream().filter(e -> !e.getTemplate().isServer()).forEach(e -> DefaultChannelManager.INSTANCE.get(e.getName()).ifPresent(s -> s.sendPacket((Packet)new PacketOutRegisterCommandsConfig())));
    }

    public static CommandsConfig getCommandsConfig() {
        return commandsConfig;
    }

    static {
        LISTENER = new ProcessListener();
    }
}

