/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.cloudflare;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.cloudflare.api.CloudFlareHelper;
import systems.reformcloud.reformcloud2.cloudflare.listener.ProcessListener;
import systems.reformcloud.reformcloud2.cloudflare.update.CloudFlareAddonUpdater;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.common.application.language.ApplicationLanguage;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.ApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.common.language.LanguageManager;
import systems.reformcloud.reformcloud2.executor.api.common.language.language.Language;

public class ReformCloudApplication
extends Application {
    private static final ProcessListener LISTENER = new ProcessListener();
    private static final ApplicationUpdateRepository REPOSITORY = new CloudFlareAddonUpdater();
    private static boolean loaded = false;

    public void onEnable() {
        try (InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("language-cloudflare.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            LanguageManager.loadAddonMessageFile((String)this.getApplication().getName(), (Language)new ApplicationLanguage(this.getApplication().getName(), properties));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (CloudFlareHelper.init(this.dataFolder().getPath())) {
            System.err.println(LanguageManager.get((String)"cloudflare-first-init", (Object[])new Object[0]));
            return;
        }
        ExecutorAPI.getInstance().getEventManager().registerListener((Object)LISTENER);
        CloudFlareHelper.loadAlreadyRunning();
        loaded = true;
    }

    public void onPreDisable() {
        if (!loaded) {
            return;
        }
        CloudFlareHelper.handleStop();
        ExecutorAPI.getInstance().getEventManager().unregisterListener((Object)LISTENER);
        ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().forEach(CloudFlareHelper::deleteRecord);
    }

    @Nullable
    public ApplicationUpdateRepository getUpdateRepository() {
        return REPOSITORY;
    }
}

