/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.cloudflare.update;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import systems.reformcloud.reformcloud2.cloudflare.ReformCloudApplication;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.ApplicationRemoteUpdate;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.basic.BasicApplicationRemoteUpdate;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.basic.DefaultApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.DownloadHelper;

public class CloudFlareAddonUpdater
extends DefaultApplicationUpdateRepository {
    private String newVersion;

    public void fetchOrigin() {
        DownloadHelper.openConnection((String)"https://internal.reformcloud.systems/version.properties", inputStream -> {
            try {
                Properties properties = new Properties();
                properties.load((InputStream)inputStream);
                this.newVersion = properties.getProperty("version");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    public boolean isNewVersionAvailable() {
        return !ReformCloudApplication.self().getApplication().applicationConfig().version().equals(this.newVersion);
    }

    @Nullable
    public ApplicationRemoteUpdate getUpdate() {
        if (!this.isNewVersionAvailable()) {
            return null;
        }
        return new BasicApplicationRemoteUpdate(this.newVersion, "https://dl.reformcloud.systems/addonsv2/reformcloud2-default-application-cloudflare-" + this.newVersion + ".jar");
    }
}

