/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.cloudflare.api;

import com.google.gson.JsonArray;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import systems.reformcloud.reformcloud2.cloudflare.config.CloudFlareConfig;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.language.LanguageManager;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;

public final class CloudFlareHelper {
    private static final String CLOUD_FLARE_API_URL = "https://api.cloudflare.com/client/v4/";
    private static final Map<UUID, String> CACHE = new ConcurrentHashMap<UUID, String>();
    private static final Map<String, String> A_RECORD_CACHE = new ConcurrentHashMap<String, String>();
    private static CloudFlareConfig cloudFlareConfig;

    private CloudFlareHelper() {
        throw new UnsupportedOperationException();
    }

    public static boolean init(@Nonnull String baseFolder) {
        if (Files.notExists(Paths.get(baseFolder + "/config.json", new String[0]), new LinkOption[0])) {
            SystemHelper.createDirectory((Path)Paths.get(baseFolder, new String[0]));
            new JsonConfiguration().add("config", (Object)new CloudFlareConfig("someone@example.com", "", "example.com", "", "@")).write(Paths.get(baseFolder + "/config.json", new String[0]));
            return true;
        }
        cloudFlareConfig = (CloudFlareConfig)JsonConfiguration.read((Path)Paths.get(baseFolder + "/config.json", new String[0])).get("config", CloudFlareConfig.TYPE_TOKEN);
        return false;
    }

    public static void loadAlreadyRunning() {
        ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().stream().filter(e -> !e.getTemplate().isServer()).forEach(CloudFlareHelper::createForProcess);
    }

    public static void createForProcess(@Nonnull ProcessInformation target) {
        String dnsID = CloudFlareHelper.createSRVRecord(target);
        if (dnsID == null) {
            return;
        }
        CACHE.put(target.getProcessUniqueID(), dnsID);
    }

    private static String createSRVRecord(ProcessInformation target) {
        String recordID;
        if (!A_RECORD_CACHE.containsKey(target.getParent()) && (recordID = CloudFlareHelper.createRecord(target, CloudFlareHelper.prepareARecord(target))) != null) {
            A_RECORD_CACHE.put(target.getParent(), recordID);
        }
        return CloudFlareHelper.createRecord(target, CloudFlareHelper.prepareConfig(target));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createRecord(ProcessInformation target, JsonConfiguration configuration) {
        try {
            InputStream stream;
            Throwable throwable;
            block41: {
                String string;
                block42: {
                    JsonArray array;
                    block39: {
                        String string2;
                        block40: {
                            JsonConfiguration result;
                            block37: {
                                String string3;
                                block38: {
                                    HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("https://api.cloudflare.com/client/v4/zones/" + cloudFlareConfig.getZoneId() + "/dns_records").openConnection();
                                    httpURLConnection.setRequestMethod("POST");
                                    httpURLConnection.setDoOutput(true);
                                    httpURLConnection.setUseCaches(false);
                                    httpURLConnection.setRequestProperty("X-Auth-Email", cloudFlareConfig.getEmail());
                                    httpURLConnection.setRequestProperty("X-Auth-Key", cloudFlareConfig.getApiToken());
                                    httpURLConnection.setRequestProperty("Accept", "application/json");
                                    httpURLConnection.setRequestProperty("Content-Type", "application/json");
                                    throwable = null;
                                    try (DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());){
                                        dataOutputStream.writeBytes(configuration.toPrettyString());
                                        dataOutputStream.flush();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    stream = httpURLConnection.getResponseCode() < 400 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                                    throwable = null;
                                    result = new JsonConfiguration(stream);
                                    httpURLConnection.disconnect();
                                    if (!result.getBoolean("success").booleanValue() || !result.has("result")) break block37;
                                    string3 = result.get("result").getString("id");
                                    if (stream == null) return string3;
                                    if (throwable == null) break block38;
                                    try {
                                        stream.close();
                                        return string3;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                        return string3;
                                    }
                                }
                                stream.close();
                                return string3;
                            }
                            array = result.getJsonObject().getAsJsonArray("errors");
                            if (array.size() != 0) break block39;
                            string2 = null;
                            if (stream == null) return string2;
                            if (throwable == null) break block40;
                            try {
                                stream.close();
                                return string2;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                return string2;
                            }
                        }
                        stream.close();
                        return string2;
                    }
                    if (array.get(0).getAsJsonObject().get("code").getAsLong() != 81057L) break block41;
                    string = null;
                    if (stream == null) return string;
                    if (throwable == null) break block42;
                    try {
                        stream.close();
                        return string;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        return string;
                    }
                }
                stream.close();
                return string;
            }
            try {
                block43: {
                    break block43;
                    catch (Throwable throwable6) {
                        // empty catch block
                    }
                }
                System.err.println(LanguageManager.get((String)"cloudlfare-create-error", (Object[])new Object[]{target.getName()}));
                return null;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            catch (Throwable throwable8) {
                throw throwable8;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void handleStop() {
        Streams.forEachValues(A_RECORD_CACHE, CloudFlareHelper::deleteRecord);
        A_RECORD_CACHE.clear();
    }

    public static void deleteRecord(ProcessInformation target) {
        String dnsID = CACHE.remove(target.getProcessUniqueID());
        if (dnsID == null) {
            return;
        }
        CloudFlareHelper.deleteRecord(dnsID);
    }

    private static void deleteRecord(String dnsID) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("https://api.cloudflare.com/client/v4/zones/" + cloudFlareConfig.getZoneId() + "/dns_records/" + dnsID).openConnection();
            httpURLConnection.setRequestMethod("DELETE");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("X-Auth-Email", cloudFlareConfig.getEmail());
            httpURLConnection.setRequestProperty("X-Auth-Key", cloudFlareConfig.getApiToken());
            httpURLConnection.setRequestProperty("Accept", "application/json");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            try (InputStream stream = httpURLConnection.getResponseCode() < 400 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();){
                new JsonConfiguration(stream);
            }
            httpURLConnection.disconnect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static JsonConfiguration prepareConfig(ProcessInformation target) {
        return new JsonConfiguration().add("type", "SRV").add("name", "_minecraft._tcp." + cloudFlareConfig.getDomainName()).add("content", "SRV 1 1 " + target.getNetworkInfo().getPort() + " " + target.getParent() + "." + cloudFlareConfig.getDomainName()).add("ttl", Integer.valueOf(1)).add("priority", Integer.valueOf(1)).add("proxied", Boolean.valueOf(false)).add("data", (Object)new JsonConfiguration().add("service", "_minecraft").add("proto", "_tcp").add("name", cloudFlareConfig.getSubDomain().equals("@") ? cloudFlareConfig.getDomainName() : cloudFlareConfig.getSubDomain()).add("priority", Integer.valueOf(1)).add("weight", Integer.valueOf(1)).add("port", Integer.valueOf(target.getNetworkInfo().getPort())).add("target", target.getParent() + "." + cloudFlareConfig.getDomainName()).getJsonObject());
    }

    private static JsonConfiguration prepareARecord(ProcessInformation processInformation) {
        return new JsonConfiguration().add("type", "A").add("name", processInformation.getParent() + "." + cloudFlareConfig.getDomainName()).add("content", processInformation.getNetworkInfo().getHost()).add("ttl", Integer.valueOf(1)).add("proxied", Boolean.valueOf(false)).add("data", (Object)new JsonConfiguration().getJsonObject());
    }
}

