/*
 * Decompiled with CFR 0.152.
 */
package systems.ora.client;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import systems.ora.client.Halo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OraClient {
    int appId = 1000401;
    String baseURL = "http://sandbox.ora.me:6196/halo";

    private JSONObject jsonifyVertices(Halo h) {
        try {
            JSONObject jvrt = new JSONObject();
            jvrt.put("size", h.getSize());
            jvrt.put("color", h.getColor());
            jvrt.put("complexity", h.getComplexity());
            jvrt.put("speed", h.getSpeed());
            jvrt.put("brightness", h.getBrightness());
            jvrt.put("wobble", h.getWobble());
            return jvrt;
        }
        catch (JSONException ex) {
            return null;
        }
    }

    private String jsonifyHalo(Halo h) {
        try {
            JSONObject job = new JSONObject();
            job.put("app", this.appId);
            if (h.getId() > 0) {
                job.put("id", h.getId());
            }
            job.put("vertices", (Object)this.jsonifyVertices(h));
            return job.toString();
        }
        catch (JSONException ex) {
            return null;
        }
    }

    private String jsonifyList(List<Halo> halos) {
        try {
            JSONObject job = new JSONObject();
            job.put("app", this.appId);
            JSONArray list = new JSONArray();
            for (Halo h : halos) {
                list.put((Object)this.jsonifyVertices(h));
            }
            job.put("vertices", (Object)list);
            return job.toString();
        }
        catch (JSONException ex) {
            return null;
        }
    }

    private String readResponse(HttpURLConnection conn) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    private HttpURLConnection sendData(URL url, String method, String data) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("User-Agent", "OraClient 0.1");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Content-Length", Integer.toString(data.getBytes().length));
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes(data);
        out.flush();
        out.close();
        return conn;
    }

    private Halo parseHalo(JSONObject job) throws JSONException {
        JSONObject vert = job.getJSONObject("vertices");
        Halo h = new Halo(this.appId, vert.getDouble("size"), vert.getDouble("color"), vert.getDouble("complexity"), vert.getDouble("speed"), vert.getDouble("brightness"), vert.getDouble("wobble"));
        h.setId(job.getInt("id"));
        return h;
    }

    private Halo readHalo(HttpURLConnection conn) throws IOException {
        String response = this.readResponse(conn);
        try {
            JSONObject job = new JSONObject(response);
            return this.parseHalo(job);
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public Halo getHalo(int id) throws IOException {
        String route = this.baseURL + "/" + Integer.toString(id);
        URL url = new URL(route);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "OraClient 0.1");
        if (conn.getResponseCode() != 200) {
            return null;
        }
        Halo h = this.readHalo(conn);
        if (conn != null) {
            conn.disconnect();
        }
        return h;
    }

    public Halo insertHalo(Halo halo) throws IOException {
        URL url = new URL(this.baseURL);
        String json = this.jsonifyHalo(halo);
        HttpURLConnection conn = this.sendData(url, "POST", json);
        Halo h = this.readHalo(conn);
        return h;
    }

    public Halo updateHalo(Halo halo) throws IOException {
        URL url = new URL(this.baseURL + "/" + halo.getId());
        String json = this.jsonifyHalo(halo);
        HttpURLConnection conn = this.sendData(url, "PUT", json);
        Halo h = this.readHalo(conn);
        return h;
    }

    public int insertHaloList(List<Halo> halos) throws IOException {
        URL url = new URL(this.baseURL + "/collection");
        String json = this.jsonifyList(halos);
        HttpURLConnection conn = this.sendData(url, "POST", json);
        String response = this.readResponse(conn);
        try {
            JSONObject job = new JSONObject(response);
            int collectionId = job.getInt("id");
            JSONArray jalos = job.getJSONArray("halos");
            for (int i = 0; i < jalos.length(); ++i) {
                JSONObject jhob = jalos.getJSONObject(i);
                Halo h = halos.get(i);
                h.setId(jhob.getInt("id"));
            }
            return collectionId;
        }
        catch (JSONException ex) {
            return -1;
        }
    }

    public ArrayList<Halo> getHaloCollection(int collectionId) throws IOException {
        URL url = new URL(this.baseURL + "/collection/" + Integer.toString(collectionId));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "OraClient 0.1");
        if (conn.getResponseCode() != 200) {
            return null;
        }
        String response = this.readResponse(conn);
        ArrayList<Halo> halos = new ArrayList<Halo>();
        try {
            JSONArray idList = new JSONArray(response);
            for (int i = 0; i < idList.length(); ++i) {
                halos.add(this.getHalo(idList.getInt(i)));
            }
            return halos;
        }
        catch (JSONException ex) {
            return null;
        }
    }
}

