/*
 * Decompiled with CFR 0.152.
 */
package systems.ora.client;

import java.security.InvalidParameterException;

public class Halo {
    private int appId;
    private int id = 0;
    private double size = 0.0;
    private double complexity = 0.0;
    private double brightness = 0.0;
    private double wobble = 0.0;
    private double color = 0.0;
    private double speed = 0.0;

    public Halo(int iAppId) {
        this.appId = iAppId;
    }

    public Halo(int iAppId, double iSize, double iColor, double iComplexity, double iSpeed, double iBrightness, double iWobble) throws InvalidParameterException {
        this.appId = iAppId;
        this.validate(iSize);
        this.validate(iColor);
        this.validate(iComplexity);
        this.validate(iSpeed);
        this.validate(iBrightness);
        this.validate(iWobble);
        this.size = iSize;
        this.color = iColor;
        this.complexity = iComplexity;
        this.speed = iSpeed;
        this.brightness = iBrightness;
        this.wobble = iWobble;
    }

    public String toString() {
        return "haloId: " + Integer.toString(this.id) + "\nappId: " + Integer.toString(this.appId) + "\nsize: " + Double.toString(this.size) + "\ncolor: " + Double.toString(this.color) + "\ncomplexity: " + Double.toString(this.complexity) + "\nspeed: " + Double.toString(this.speed) + "\nbrightness: " + Double.toString(this.brightness) + "\nwobble: " + Double.toString(this.wobble) + "\n";
    }

    public int getId() {
        return this.id;
    }

    public double getSize() {
        return this.size;
    }

    public double getColor() {
        return this.color;
    }

    public double getComplexity() {
        return this.complexity;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public double getWobble() {
        return this.wobble;
    }

    public void setId(int haloId) {
        this.id = haloId;
    }

    public void setSize(double s) throws InvalidParameterException {
        this.validate(s);
        this.size = s;
    }

    public void setColor(double c) throws InvalidParameterException {
        this.validate(c);
        this.color = c;
    }

    public void setComplexity(double c) throws InvalidParameterException {
        this.validate(c);
        this.complexity = c;
    }

    public void setSpeed(double s) throws InvalidParameterException {
        this.validate(s);
        this.speed = s;
    }

    public void setBrightness(double b) throws InvalidParameterException {
        this.validate(b);
        this.brightness = b;
    }

    public void setWobble(double w) throws InvalidParameterException {
        this.validate(w);
        this.wobble = w;
    }

    private void validate(double val) throws InvalidParameterException {
        if (val < 0.0 || val > 1.0) {
            throw new InvalidParameterException();
        }
    }
}

