/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import systems.microservice.log4j2.elasticsearch.appender.ByteArrayOutputStream;
import systems.microservice.log4j2.elasticsearch.appender.ElasticSearchAppender;
import systems.microservice.log4j2.elasticsearch.appender.Util;

final class InputLogEvent
extends UpdateRequest
implements Comparable<InputLogEvent> {
    private static final int SIZE_OVERHEAD = 64;
    private static final String PROCESS_UUID = ElasticSearchAppender.PROCESS_UUID.toString();
    private static final long MOST_SIG_BITS = ElasticSearchAppender.PROCESS_UUID.getMostSignificantBits();
    private static final AtomicLong THREAD_LEAST_SIG_BITS = new AtomicLong(0L);
    private static final AtomicLong EVENT_LEAST_SIG_BITS = new AtomicLong(0L);
    private static final ThreadLocal<String> THREAD_UUID = ThreadLocal.withInitial(() -> new UUID(MOST_SIG_BITS, THREAD_LEAST_SIG_BITS.getAndIncrement()).toString());
    public final long time;
    public final int size;

    public InputLogEvent(boolean start, AtomicLong totalCount, AtomicLong totalSize, long lostCount, long lostSize, String name, String url, String index, boolean enable, int countMax, long sizeMax, int bulkCountMax, long bulkSizeMax, long delayMax, int bulkRetryCount, long bulkRetryDelay, int lengthStringMax, boolean out, boolean setDefaultUncaughtExceptionHandler) {
        super(null, new UUID(MOST_SIG_BITS, EVENT_LEAST_SIG_BITS.getAndIncrement()).toString());
        this.time = start ? ElasticSearchAppender.PROCESS_START_TIME : System.currentTimeMillis();
        this.docAsUpsert(true);
        try {
            Thread t = Thread.currentThread();
            ByteArrayOutputStream buf = new ByteArrayOutputStream(65536);
            XContentBuilder cb = XContentFactory.smileBuilder((OutputStream)((Object)buf));
            cb.humanReadable(true);
            cb.startObject();
            cb.timeField("time", (Object)this.time);
            if (start) {
                cb.field("type", "START");
            } else {
                cb.field("type", "FINISH");
            }
            cb.field("process.id", ElasticSearchAppender.PROCESS_ID);
            cb.field("process.uuid", PROCESS_UUID);
            cb.timeField("process.start.time", (Object)ElasticSearchAppender.PROCESS_START_TIME);
            if (!start) {
                cb.timeField("process.finish.time", (Object)this.time);
            }
            InputLogEvent.addField(cb, "process.variables", InputLogEvent.createProcessVariables(), lengthStringMax);
            InputLogEvent.addField(cb, "process.properties", InputLogEvent.createProcessProperties(), lengthStringMax);
            InputLogEvent.addField(cb, "process.cmdline", Util.loadString(String.format("/proc/%d/cmdline", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
            InputLogEvent.addField(cb, "process.io", Util.loadString(String.format("/proc/%d/io", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
            InputLogEvent.addField(cb, "process.limits", Util.loadString(String.format("/proc/%d/limits", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
            InputLogEvent.addField(cb, "process.mounts", Util.loadString(String.format("/proc/%d/mounts", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
            InputLogEvent.addField(cb, "process.net.dev", Util.loadString(String.format("/proc/%d/net/dev", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
            InputLogEvent.addField(cb, "process.net.protocols", Util.loadString(String.format("/proc/%d/net/protocols", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
            for (Map.Entry<String, String> e : ElasticSearchAppender.LOG_TAGS.entrySet()) {
                InputLogEvent.addField(cb, e.getKey(), e.getValue(), lengthStringMax);
            }
            cb.field("host.name", ElasticSearchAppender.HOST_NAME);
            cb.field("host.ip", ElasticSearchAppender.HOST_IP);
            cb.field("logger", ElasticSearchAppender.class.getName());
            cb.field("thread.id", t.getId());
            cb.field("thread.uuid", THREAD_UUID.get());
            InputLogEvent.addField(cb, "thread.name", t.getName(), lengthStringMax);
            cb.field("thread.priority", t.getPriority());
            cb.field("level", "INFO");
            if (start) {
                cb.field("message", "Hello World!");
            } else {
                cb.field("message", "Goodbye World!");
            }
            InputLogEvent.addField(cb, "appender.name", name, lengthStringMax);
            InputLogEvent.addField(cb, "appender.url", url, lengthStringMax);
            InputLogEvent.addField(cb, "appender.index", index, lengthStringMax);
            cb.field("appender.enable", enable);
            cb.field("appender.count.max", countMax);
            cb.field("appender.size.max", sizeMax);
            cb.field("appender.bulk.count.max", bulkCountMax);
            cb.field("appender.bulk.size.max", bulkSizeMax);
            cb.field("appender.delay.max", delayMax);
            cb.field("appender.bulk.retry.count", bulkRetryCount);
            cb.field("appender.bulk.retry.delay", bulkRetryDelay);
            cb.field("appender.length.string.max", lengthStringMax);
            cb.field("appender.out", out);
            cb.field("appender.set.default.uncaught.exception.handler", setDefaultUncaughtExceptionHandler);
            cb.flush();
            this.size = buf.size() + 64;
            cb.field("size", this.size);
            cb.field("total.count", totalCount.incrementAndGet());
            cb.field("total.size", totalSize.addAndGet(this.size));
            cb.field("lost.count", lostCount);
            cb.field("lost.size", lostSize);
            cb.endObject();
            this.doc(cb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputLogEvent(LogEvent event, AtomicLong totalCount, AtomicLong totalSize, long lostCount, long lostSize, int lengthStringMax) {
        super(null, new UUID(MOST_SIG_BITS, EVENT_LEAST_SIG_BITS.getAndIncrement()).toString());
        this.time = event.getTimeMillis();
        this.docAsUpsert(true);
        try {
            ReadOnlyStringMap ctx;
            Marker mrk;
            StackTraceElement ste;
            Throwable ex = event.getThrown();
            ByteArrayOutputStream buf = new ByteArrayOutputStream(ex == null ? 1024 : 4096);
            XContentBuilder cb = XContentFactory.smileBuilder((OutputStream)((Object)buf));
            cb.humanReadable(true);
            cb.startObject();
            cb.timeField("time", (Object)this.time);
            cb.field("type", ex == null ? "DEFAULT" : "EXCEPTION");
            cb.field("process.id", ElasticSearchAppender.PROCESS_ID);
            cb.field("process.uuid", PROCESS_UUID);
            cb.timeField("process.start.time", (Object)ElasticSearchAppender.PROCESS_START_TIME);
            for (Map.Entry<String, String> e : ElasticSearchAppender.LOG_TAGS.entrySet()) {
                InputLogEvent.addField(cb, e.getKey(), e.getValue(), lengthStringMax);
            }
            cb.field("host.name", ElasticSearchAppender.HOST_NAME);
            cb.field("host.ip", ElasticSearchAppender.HOST_IP);
            InputLogEvent.addField(cb, "logger", event.getLoggerName(), lengthStringMax);
            cb.field("thread.id", event.getThreadId());
            cb.field("thread.uuid", THREAD_UUID.get());
            InputLogEvent.addField(cb, "thread.name", event.getThreadName(), lengthStringMax);
            cb.field("thread.priority", event.getThreadPriority());
            Level l = event.getLevel();
            if (l != null) {
                InputLogEvent.addField(cb, "level", l.toString(), lengthStringMax);
            } else {
                cb.field("level", "INFO");
            }
            Message m = event.getMessage();
            if (m != null) {
                InputLogEvent.addField(cb, "message", m.getFormattedMessage(), lengthStringMax);
            }
            if ((ste = event.getSource()) != null) {
                InputLogEvent.addField(cb, "source.file", ste.getFileName(), lengthStringMax);
                InputLogEvent.addField(cb, "source.class", ste.getClassName(), lengthStringMax);
                InputLogEvent.addField(cb, "source.method", ste.getMethodName(), lengthStringMax);
                cb.field("source.line", ste.getLineNumber());
            }
            if (ex != null) {
                Throwable cex;
                InputLogEvent.addField(cb, "exception.class", ex.getClass().getName(), lengthStringMax);
                InputLogEvent.addField(cb, "exception.message", ex.getMessage(), lengthStringMax);
                try (StringBuilderWriter sbw = new StringBuilderWriter(4096);){
                    ex.printStackTrace(new PrintWriter((Writer)sbw, false));
                    InputLogEvent.addField(cb, "exception.stacktrace", sbw.toString(), lengthStringMax);
                }
                Throwable[] sex = ex.getSuppressed();
                if (sex != null) {
                    cb.field("exception.suppressed.count", sex.length);
                }
                if ((cex = ex.getCause()) != null) {
                    InputLogEvent.addField(cb, "exception.cause.class", cex.getClass().getName(), lengthStringMax);
                    InputLogEvent.addField(cb, "exception.cause.message", cex.getMessage(), lengthStringMax);
                }
            }
            if ((mrk = event.getMarker()) != null) {
                InputLogEvent.addField(cb, "marker.name", mrk.getName(), lengthStringMax);
                cb.field("marker.parents", mrk.hasParents());
            }
            if ((ctx = event.getContextData()) != null) {
                ctx.forEach((k, v) -> {
                    if (k != null && v != null) {
                        InputLogEvent.addField(cb, "context." + k, v.toString(), lengthStringMax);
                    }
                });
            }
            cb.flush();
            this.size = buf.size() + 64;
            cb.field("size", this.size);
            cb.field("total.count", totalCount.incrementAndGet());
            cb.field("total.size", totalSize.addAndGet(this.size));
            cb.field("lost.count", lostCount);
            cb.field("lost.size", lostSize);
            cb.endObject();
            this.doc(cb);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(InputLogEvent event) {
        if (this.time < event.time) {
            return -1;
        }
        if (this.time > event.time) {
            return 1;
        }
        return 0;
    }

    private static void addField(XContentBuilder builder, String name, String value, int lengthMax) {
        if (name != null && value != null) {
            try {
                builder.field(name, Util.cut(value, lengthMax));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String createProcessVariables() {
        Map<String, String> evs = System.getenv();
        StringBuilder sb = new StringBuilder(32768);
        for (Map.Entry<String, String> e : evs.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            if (k == null || v == null) continue;
            sb.append(k);
            sb.append("=");
            sb.append(v);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String createProcessProperties() {
        Properties sps = System.getProperties();
        StringBuilder sb = new StringBuilder(32768);
        for (Map.Entry<Object, Object> e : sps.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k == null || v == null || !(k instanceof String) || !(v instanceof String)) continue;
            String ks = (String)k;
            String vs = (String)v;
            sb.append(ks);
            sb.append("=");
            sb.append(vs);
            sb.append("\n");
        }
        return sb.toString();
    }
}

