/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import systems.microservice.log4j2.elasticsearch.appender.ElasticSearchAppender;
import systems.microservice.log4j2.elasticsearch.appender.Index;
import systems.microservice.log4j2.elasticsearch.appender.InputLogEvent;
import systems.microservice.log4j2.elasticsearch.appender.ThreadSection;
import systems.microservice.log4j2.elasticsearch.appender.Util;

final class Buffer {
    private final ThreadSection section = new ThreadSection(true);
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicLong size = new AtomicLong(0L);
    private final int countMax;
    private final long sizeMax;
    private final int bulkCountMax;
    private final long bulkSizeMax;
    private final int bulkRetryCount;
    private final long bulkRetryDelay;
    private final ConcurrentLinkedQueue<InputLogEvent> eventsQueue;
    private final ArrayList<InputLogEvent> eventsList;

    public Buffer(int countMax, long sizeMax, int bulkCountMax, long bulkSizeMax, int bulkRetryCount, long bulkRetryDelay) {
        this.countMax = countMax;
        this.sizeMax = sizeMax;
        this.bulkCountMax = bulkCountMax;
        this.bulkSizeMax = bulkSizeMax;
        this.bulkRetryCount = bulkRetryCount;
        this.bulkRetryDelay = bulkRetryDelay;
        this.eventsQueue = new ConcurrentLinkedQueue();
        this.eventsList = new ArrayList(countMax);
    }

    public boolean isReady() {
        return this.section.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(InputLogEvent event) {
        if (this.section.enter()) {
            try {
                if (this.count.get() + 1 < this.countMax) {
                    long s;
                    int c;
                    long es = event.size;
                    if (this.size.get() + es < this.sizeMax && (c = this.count.incrementAndGet()) < this.countMax && (s = this.size.addAndGet(es)) < this.sizeMax) {
                        this.eventsQueue.offer(event);
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.section.leave();
            }
            this.section.disable();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(AtomicBoolean enabled, RestHighLevelClient client, String name, String url, String index, AtomicLong lostCount, AtomicLong lostSize, boolean out) {
        block10: {
            this.section.disable();
            try {
                this.section.await();
                if (this.count.get() <= 0) break block10;
                try {
                    for (InputLogEvent e : this.eventsQueue) {
                        this.eventsList.add(e);
                    }
                    Collections.sort(this.eventsList);
                    Index idx = null;
                    int bc = 0;
                    long bs = 0L;
                    BulkRequest r = new BulkRequest(null);
                    for (InputLogEvent e : this.eventsList) {
                        if (idx == null || !idx.contains(e)) {
                            idx = new Index(index, e);
                        }
                        e.index(idx.name);
                        if (bc >= this.bulkCountMax || bs >= this.bulkSizeMax) {
                            this.putEvents(enabled, client, name, url, index, lostCount, lostSize, out, r);
                            r = new BulkRequest(null);
                            bc = 0;
                            bs = 0L;
                        }
                        r.add((UpdateRequest)e);
                        ++bc;
                        bs += (long)e.size;
                    }
                    this.putEvents(enabled, client, name, url, index, lostCount, lostSize, out, r);
                }
                finally {
                    this.eventsList.clear();
                    this.eventsQueue.clear();
                    this.size.set(0L);
                    this.count.set(0);
                }
            }
            finally {
                this.section.enable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEvents(AtomicBoolean enabled, RestHighLevelClient client, String name, String url, String index, AtomicLong lostCount, AtomicLong lostSize, boolean out, BulkRequest request) {
        int fc = 0;
        long fs = 0L;
        try {
            for (int i = 0; request.numberOfActions() > 0 && i < this.bulkRetryCount; ++i) {
                BulkResponse rsp = null;
                try {
                    rsp = client.bulk(request, RequestOptions.DEFAULT);
                }
                catch (Exception ex) {
                    fc = 0;
                    fs = 0L;
                    List es = request.requests();
                    for (DocWriteRequest e : es) {
                        if (!(e instanceof InputLogEvent)) continue;
                        InputLogEvent ile = (InputLogEvent)e;
                        ++fc;
                        fs += (long)ile.size;
                    }
                    ElasticSearchAppender.logSystem(out, Buffer.class, String.format("Attempt %d to put %d events to ElasticSearch (%s, %s, %s) is failed with %s: %s", i, request.numberOfActions(), name, url, index, ex.getClass().getSimpleName(), ex.getMessage()));
                    if (Util.delay(enabled, this.bulkRetryDelay, 200L)) continue;
                    lostCount.addAndGet(fc);
                    lostSize.addAndGet(fs);
                    return;
                }
                fc = 0;
                fs = 0L;
                if (!rsp.hasFailures()) {
                    return;
                }
                BulkItemResponse[] irs = rsp.getItems();
                HashSet<String> fids = new HashSet<String>(Math.max(fc, 16));
                for (BulkItemResponse ir : irs) {
                    fids.add(ir.getId());
                }
                BulkRequest r = new BulkRequest(null);
                List es = request.requests();
                for (DocWriteRequest e : es) {
                    if (!fids.contains(e.id()) || !(e instanceof InputLogEvent)) continue;
                    InputLogEvent ile = (InputLogEvent)e;
                    r.add((UpdateRequest)ile);
                    ++fc;
                    fs += (long)ile.size;
                }
                ElasticSearchAppender.logSystem(out, Buffer.class, String.format("Attempt %d to put %d events to ElasticSearch (%s, %s, %s) contains %d failed events of size %d", i, request.numberOfActions(), name, url, index, fc, fs));
                request = r;
                if (Util.delay(enabled, this.bulkRetryDelay, 200L)) continue;
                return;
            }
        }
        finally {
            lostCount.addAndGet(fc);
            lostSize.addAndGet(fs);
        }
    }
}

