/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import systems.microservice.log4j2.elasticsearch.appender.InputLogEvent;

final class Index {
    public static final long DAY_MILLIS = 86400000L;
    public final String prefix;
    public final String name;
    public final long timeBegin;
    public final long timeEnd;

    public Index(String prefix, InputLogEvent event) {
        long tb = Index.createTimeBegin(event.time);
        this.prefix = prefix;
        this.name = String.format("%s-%s", prefix, String.format("%1$tY.%1$tm.%1$td", tb));
        this.timeBegin = tb;
        this.timeEnd = tb + 86400000L;
    }

    public boolean contains(InputLogEvent event) {
        return event.time >= this.timeBegin && event.time < this.timeEnd;
    }

    private static long createTimeBegin(long time) {
        long d = time / 86400000L;
        return d * 86400000L;
    }
}

