/*
 * Decompiled with CFR 0.152.
 */
package systems.microservice.log4j2.elasticsearch.appender;

import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import systems.microservice.log4j2.elasticsearch.appender.ByteArrayOutputStream;
import systems.microservice.log4j2.elasticsearch.appender.ElasticSearchAppender;
import systems.microservice.log4j2.elasticsearch.appender.Util;

final class InputLogEvent
implements Comparable<InputLogEvent> {
    private static final long MB = 0x100000L;
    private static final int SIZE_OVERHEAD = 64;
    private static final SmileFactory SMILE_FACTORY = new SmileFactory();
    private static final String PROCESS_UUID = ElasticSearchAppender.PROCESS_UUID.toString();
    private static final long MOST_SIG_BITS = ElasticSearchAppender.PROCESS_UUID.getMostSignificantBits();
    private static final AtomicLong THREAD_LEAST_SIG_BITS = new AtomicLong(0L);
    private static final AtomicLong EVENT_LEAST_SIG_BITS = new AtomicLong(0L);
    private static final ThreadLocal<String> THREAD_UUID = ThreadLocal.withInitial(() -> new UUID(MOST_SIG_BITS, THREAD_LEAST_SIG_BITS.getAndIncrement()).toString());
    private static final AtomicReference<CpuUsage> CPU_USAGE = new AtomicReference<CpuUsage>(new CpuUsage());
    private static final AtomicReference<MemoryUsage> MEMORY_USAGE = new AtomicReference<MemoryUsage>(new MemoryUsage());
    private static final AtomicReference<DiskUsage> DISK_USAGE = new AtomicReference<DiskUsage>(new DiskUsage());
    private static final AtomicReference<ClassUsage> CLASS_USAGE = new AtomicReference<ClassUsage>(new ClassUsage());
    private static final AtomicReference<ThreadUsage> THREAD_USAGE = new AtomicReference<ThreadUsage>(new ThreadUsage());
    private static final Thread MONITOR_THREAD_3 = new Thread("log4j2-elasticsearch-appender-monitor-3"){

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        MEMORY_USAGE.set(new MemoryUsage());
                        CLASS_USAGE.set(new ClassUsage());
                        THREAD_USAGE.set(new ThreadUsage());
                        try {
                            Thread.sleep(3000L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    };
    private static final Thread MONITOR_THREAD_10;
    public final String id = new UUID(MOST_SIG_BITS, EVENT_LEAST_SIG_BITS.getAndIncrement()).toString();
    public final long time;
    public final ByteArrayOutputStream data;
    public final int size;
    public String index = null;

    public InputLogEvent(boolean start, AtomicLong totalCount, AtomicLong totalSize, long lostCount, long lostSize, String name, String url, String user, String index, boolean enable, int countMax, long sizeMax, int bulkCountMax, long bulkSizeMax, long delayMax, int bulkRetryCount, long bulkRetryDelay, int eventSizeStartFinish, int eventSizeDefault, int eventSizeException, int lengthStringMax, boolean out, boolean setDefaultUncaughtExceptionHandler) {
        this.time = start ? ElasticSearchAppender.PROCESS_START : System.currentTimeMillis();
        try {
            Thread t = Thread.currentThread();
            this.data = new ByteArrayOutputStream(eventSizeStartFinish);
            try (SmileGenerator gen = SMILE_FACTORY.createGenerator((OutputStream)this.data);){
                gen.writeStartObject();
                gen.writeNumberField("time", this.time);
                if (start) {
                    gen.writeStringField("type", "START");
                } else {
                    gen.writeStringField("type", "FINISH");
                }
                gen.writeStringField("platform", "JAVA");
                gen.writeNumberField("process.id", ElasticSearchAppender.PROCESS_ID);
                gen.writeStringField("process.uuid", PROCESS_UUID);
                gen.writeNumberField("process.start", ElasticSearchAppender.PROCESS_START);
                if (!start) {
                    gen.writeNumberField("process.finish", this.time);
                }
                InputLogEvent.addField(gen, "process.variables", InputLogEvent.createProcessVariables(), lengthStringMax);
                InputLogEvent.addField(gen, "process.properties", InputLogEvent.createProcessProperties(), lengthStringMax);
                InputLogEvent.addField(gen, "process.cmdline", Util.loadString(String.format("/proc/%d/cmdline", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
                InputLogEvent.addField(gen, "process.io", Util.loadString(String.format("/proc/%d/io", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
                InputLogEvent.addField(gen, "process.limits", Util.loadString(String.format("/proc/%d/limits", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
                InputLogEvent.addField(gen, "process.mounts", Util.loadString(String.format("/proc/%d/mounts", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
                InputLogEvent.addField(gen, "process.net.dev", Util.loadString(String.format("/proc/%d/net/dev", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
                InputLogEvent.addField(gen, "process.net.protocols", Util.loadString(String.format("/proc/%d/net/protocols", ElasticSearchAppender.PROCESS_ID), "unknown"), lengthStringMax);
                InputLogEvent.addField(gen, "host.name", ElasticSearchAppender.HOST_NAME, 256);
                InputLogEvent.addField(gen, "host.ip", ElasticSearchAppender.HOST_IP, 64);
                for (Map.Entry<String, String> e : ElasticSearchAppender.LOG_TAGS.entrySet()) {
                    InputLogEvent.addField(gen, e.getKey(), e.getValue(), lengthStringMax);
                }
                gen.writeStringField("logger", ElasticSearchAppender.class.getName());
                gen.writeNumberField("thread.id", t.getId());
                gen.writeStringField("thread.uuid", THREAD_UUID.get());
                InputLogEvent.addField(gen, "thread.name", t.getName(), 512);
                gen.writeNumberField("thread.priority", t.getPriority());
                CpuUsage cpu = CPU_USAGE.get();
                gen.writeNumberField("cpu.count", cpu.count);
                gen.writeNumberField("cpu.m1", cpu.m1);
                gen.writeNumberField("cpu.m5", cpu.m5);
                gen.writeNumberField("cpu.m15", cpu.m15);
                gen.writeNumberField("cpu.entity.active", cpu.entityActive);
                gen.writeNumberField("cpu.entity.total", cpu.entityTotal);
                MemoryUsage memory = MEMORY_USAGE.get();
                gen.writeNumberField("memory.heap.init", memory.heapInit);
                gen.writeNumberField("memory.heap.used", memory.heapUsed);
                gen.writeNumberField("memory.heap.committed", memory.heapCommitted);
                gen.writeNumberField("memory.heap.max", memory.heapMax);
                gen.writeNumberField("memory.nonheap.init", memory.nonHeapInit);
                gen.writeNumberField("memory.nonheap.used", memory.nonHeapUsed);
                gen.writeNumberField("memory.nonheap.committed", memory.nonHeapCommitted);
                gen.writeNumberField("memory.nonheap.max", memory.nonHeapMax);
                gen.writeNumberField("memory.object.pending.finalization", memory.objectPendingFinalization);
                DiskUsage disk = DISK_USAGE.get();
                gen.writeNumberField("disk.total", disk.total);
                gen.writeNumberField("disk.free", disk.free);
                gen.writeNumberField("disk.usable", disk.usable);
                ClassUsage clazz = CLASS_USAGE.get();
                gen.writeNumberField("class.active", clazz.active);
                gen.writeNumberField("class.loaded", clazz.loaded);
                gen.writeNumberField("class.unloaded", clazz.unloaded);
                ThreadUsage thread = THREAD_USAGE.get();
                gen.writeNumberField("thread.live", thread.live);
                gen.writeNumberField("thread.daemon", thread.daemon);
                gen.writeNumberField("thread.peak", thread.peak);
                gen.writeNumberField("thread.total", thread.total);
                gen.writeStringField("level", "INFO");
                if (start) {
                    gen.writeStringField("message", "Hello World!");
                } else {
                    gen.writeStringField("message", "Goodbye World!");
                }
                InputLogEvent.addField(gen, "appender.name", name, 256);
                InputLogEvent.addField(gen, "appender.url", url, lengthStringMax);
                InputLogEvent.addField(gen, "appender.user", user, 256);
                InputLogEvent.addField(gen, "appender.index", index, 256);
                gen.writeBooleanField("appender.enable", enable);
                gen.writeNumberField("appender.count.max", countMax);
                gen.writeNumberField("appender.size.max", sizeMax);
                gen.writeNumberField("appender.bulk.count.max", bulkCountMax);
                gen.writeNumberField("appender.bulk.size.max", bulkSizeMax);
                gen.writeNumberField("appender.delay.max", delayMax);
                gen.writeNumberField("appender.bulk.retry.count", bulkRetryCount);
                gen.writeNumberField("appender.bulk.retry.delay", bulkRetryDelay);
                gen.writeNumberField("appender.event.size.start.finish", eventSizeStartFinish);
                gen.writeNumberField("appender.event.size.default", eventSizeDefault);
                gen.writeNumberField("appender.event.size.exception", eventSizeException);
                gen.writeNumberField("appender.length.string.max", lengthStringMax);
                gen.writeBooleanField("appender.out", out);
                gen.writeBooleanField("appender.set.default.uncaught.exception.handler", setDefaultUncaughtExceptionHandler);
                gen.flush();
                this.size = this.data.size() + 64;
                gen.writeNumberField("size", this.size);
                gen.writeNumberField("total.count", totalCount.incrementAndGet());
                gen.writeNumberField("total.size", totalSize.addAndGet(this.size));
                gen.writeNumberField("lost.count", lostCount);
                gen.writeNumberField("lost.size", lostSize);
                gen.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputLogEvent(LogEvent event, AtomicLong totalCount, AtomicLong totalSize, long lostCount, long lostSize, int eventSizeDefault, int eventSizeException, int lengthStringMax) {
        this.time = event.getTimeMillis();
        try {
            Throwable ex = event.getThrown();
            this.data = new ByteArrayOutputStream(ex == null ? eventSizeDefault : eventSizeException);
            try (SmileGenerator gen = SMILE_FACTORY.createGenerator((OutputStream)this.data);){
                ReadOnlyStringMap ctx;
                Marker mrk;
                StackTraceElement ste;
                gen.writeStartObject();
                gen.writeNumberField("time", this.time);
                gen.writeStringField("type", ex == null ? "DEFAULT" : "EXCEPTION");
                gen.writeStringField("platform", "JAVA");
                gen.writeNumberField("process.id", ElasticSearchAppender.PROCESS_ID);
                gen.writeStringField("process.uuid", PROCESS_UUID);
                gen.writeNumberField("process.start", ElasticSearchAppender.PROCESS_START);
                InputLogEvent.addField(gen, "host.name", ElasticSearchAppender.HOST_NAME, 256);
                InputLogEvent.addField(gen, "host.ip", ElasticSearchAppender.HOST_IP, 64);
                for (Map.Entry<String, String> e : ElasticSearchAppender.LOG_TAGS.entrySet()) {
                    InputLogEvent.addField(gen, e.getKey(), e.getValue(), lengthStringMax);
                }
                InputLogEvent.addField(gen, "logger", event.getLoggerName(), 512);
                gen.writeNumberField("thread.id", event.getThreadId());
                gen.writeStringField("thread.uuid", THREAD_UUID.get());
                InputLogEvent.addField(gen, "thread.name", event.getThreadName(), 512);
                gen.writeNumberField("thread.priority", event.getThreadPriority());
                CpuUsage cpu = CPU_USAGE.get();
                gen.writeNumberField("cpu.count", cpu.count);
                gen.writeNumberField("cpu.m1", cpu.m1);
                gen.writeNumberField("cpu.m5", cpu.m5);
                gen.writeNumberField("cpu.m15", cpu.m15);
                gen.writeNumberField("cpu.entity.active", cpu.entityActive);
                gen.writeNumberField("cpu.entity.total", cpu.entityTotal);
                MemoryUsage memory = MEMORY_USAGE.get();
                gen.writeNumberField("memory.heap.init", memory.heapInit);
                gen.writeNumberField("memory.heap.used", memory.heapUsed);
                gen.writeNumberField("memory.heap.committed", memory.heapCommitted);
                gen.writeNumberField("memory.heap.max", memory.heapMax);
                gen.writeNumberField("memory.nonheap.init", memory.nonHeapInit);
                gen.writeNumberField("memory.nonheap.used", memory.nonHeapUsed);
                gen.writeNumberField("memory.nonheap.committed", memory.nonHeapCommitted);
                gen.writeNumberField("memory.nonheap.max", memory.nonHeapMax);
                gen.writeNumberField("memory.object.pending.finalization", memory.objectPendingFinalization);
                DiskUsage disk = DISK_USAGE.get();
                gen.writeNumberField("disk.total", disk.total);
                gen.writeNumberField("disk.free", disk.free);
                gen.writeNumberField("disk.usable", disk.usable);
                ClassUsage clazz = CLASS_USAGE.get();
                gen.writeNumberField("class.active", clazz.active);
                gen.writeNumberField("class.loaded", clazz.loaded);
                gen.writeNumberField("class.unloaded", clazz.unloaded);
                ThreadUsage thread = THREAD_USAGE.get();
                gen.writeNumberField("thread.live", thread.live);
                gen.writeNumberField("thread.daemon", thread.daemon);
                gen.writeNumberField("thread.peak", thread.peak);
                gen.writeNumberField("thread.total", thread.total);
                Level l = event.getLevel();
                if (l != null) {
                    InputLogEvent.addField(gen, "level", l.toString(), 256);
                } else {
                    gen.writeStringField("level", "INFO");
                }
                Message m = event.getMessage();
                if (m != null) {
                    InputLogEvent.addField(gen, "message", m.getFormattedMessage(), lengthStringMax);
                }
                if ((ste = event.getSource()) != null) {
                    InputLogEvent.addField(gen, "source.file", ste.getFileName(), 512);
                    InputLogEvent.addField(gen, "source.class", ste.getClassName(), 512);
                    InputLogEvent.addField(gen, "source.method", ste.getMethodName(), 512);
                    gen.writeNumberField("source.line", ste.getLineNumber());
                }
                if (ex != null) {
                    Throwable cex;
                    InputLogEvent.addField(gen, "exception.class", ex.getClass().getName(), 512);
                    InputLogEvent.addField(gen, "exception.message", ex.getMessage(), lengthStringMax);
                    try (StringBuilderWriter sbw = new StringBuilderWriter(4096);){
                        ex.printStackTrace(new PrintWriter((Writer)sbw, false));
                        InputLogEvent.addField(gen, "exception.stacktrace", sbw.toString(), lengthStringMax);
                    }
                    Throwable[] sex = ex.getSuppressed();
                    if (sex != null) {
                        gen.writeNumberField("exception.suppressed.count", sex.length);
                    }
                    if ((cex = ex.getCause()) != null) {
                        InputLogEvent.addField(gen, "exception.cause.class", cex.getClass().getName(), 512);
                        InputLogEvent.addField(gen, "exception.cause.message", cex.getMessage(), lengthStringMax);
                    }
                }
                if ((mrk = event.getMarker()) != null) {
                    InputLogEvent.addField(gen, "marker.name", mrk.getName(), 512);
                    gen.writeBooleanField("marker.parents", mrk.hasParents());
                }
                if ((ctx = event.getContextData()) != null) {
                    ctx.forEach((k, v) -> {
                        if (k != null && v != null) {
                            InputLogEvent.addField(gen, "context." + k, v.toString(), lengthStringMax);
                        }
                    });
                }
                gen.flush();
                this.size = this.data.size() + 64;
                gen.writeNumberField("size", this.size);
                gen.writeNumberField("total.count", totalCount.incrementAndGet());
                gen.writeNumberField("total.size", totalSize.addAndGet(this.size));
                gen.writeNumberField("lost.count", lostCount);
                gen.writeNumberField("lost.size", lostSize);
                gen.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(InputLogEvent event) {
        if (this.time < event.time) {
            return -1;
        }
        if (this.time > event.time) {
            return 1;
        }
        return 0;
    }

    private static void addField(SmileGenerator generator, String name, String value, int lengthMax) {
        if (name != null && value != null) {
            try {
                generator.writeStringField(name, Util.cut(value, lengthMax));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String createProcessVariables() {
        Map<String, String> evs = System.getenv();
        StringBuilder sb = new StringBuilder(32768);
        for (Map.Entry<String, String> e : evs.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            if (k == null || v == null) continue;
            sb.append(k);
            sb.append("=");
            sb.append(v);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String createProcessProperties() {
        Properties sps = System.getProperties();
        StringBuilder sb = new StringBuilder(32768);
        for (Map.Entry<Object, Object> e : sps.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (k == null || v == null || !(k instanceof String) || !(v instanceof String)) continue;
            String ks = (String)k;
            String vs = (String)v;
            sb.append(ks);
            sb.append("=");
            sb.append(vs);
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        MONITOR_THREAD_3.setDaemon(true);
        MONITOR_THREAD_3.start();
        MONITOR_THREAD_10 = new Thread("log4j2-elasticsearch-appender-monitor-10"){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            CPU_USAGE.set(new CpuUsage());
                            DISK_USAGE.set(new DiskUsage());
                            try {
                                Thread.sleep(10000L);
                                continue block4;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        };
        MONITOR_THREAD_10.setDaemon(true);
        MONITOR_THREAD_10.start();
    }

    private static final class ThreadUsage {
        private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
        public final int live = THREAD_MX_BEAN.getThreadCount();
        public final int daemon = THREAD_MX_BEAN.getDaemonThreadCount();
        public final int peak = THREAD_MX_BEAN.getPeakThreadCount();
        public final long total = THREAD_MX_BEAN.getTotalStartedThreadCount();
    }

    private static final class ClassUsage {
        private static final ClassLoadingMXBean CLASS_LOADING_MX_BEAN = ManagementFactory.getClassLoadingMXBean();
        public final int active = CLASS_LOADING_MX_BEAN.getLoadedClassCount();
        public final long loaded = CLASS_LOADING_MX_BEAN.getTotalLoadedClassCount();
        public final long unloaded = CLASS_LOADING_MX_BEAN.getUnloadedClassCount();
    }

    private static final class DiskUsage {
        private static final File ROOT_DISK = new File("/");
        public final long total = ROOT_DISK.getTotalSpace() / 0x100000L;
        public final long free = ROOT_DISK.getFreeSpace() / 0x100000L;
        public final long usable = ROOT_DISK.getUsableSpace() / 0x100000L;
    }

    private static final class MemoryUsage {
        private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
        public final long heapInit;
        public final long heapUsed;
        public final long heapCommitted;
        public final long heapMax;
        public final long nonHeapInit;
        public final long nonHeapUsed;
        public final long nonHeapCommitted;
        public final long nonHeapMax;
        public final int objectPendingFinalization;

        public MemoryUsage() {
            java.lang.management.MemoryUsage hmu = MEMORY_MX_BEAN.getHeapMemoryUsage();
            java.lang.management.MemoryUsage nhmu = MEMORY_MX_BEAN.getNonHeapMemoryUsage();
            this.heapInit = hmu.getInit() / 0x100000L;
            this.heapUsed = hmu.getUsed() / 0x100000L;
            this.heapCommitted = hmu.getCommitted() / 0x100000L;
            this.heapMax = hmu.getMax() / 0x100000L;
            this.nonHeapInit = nhmu.getInit() / 0x100000L;
            this.nonHeapUsed = nhmu.getUsed() / 0x100000L;
            this.nonHeapCommitted = nhmu.getCommitted() / 0x100000L;
            this.nonHeapMax = nhmu.getMax() / 0x100000L;
            this.objectPendingFinalization = MEMORY_MX_BEAN.getObjectPendingFinalizationCount();
        }
    }

    private static final class CpuUsage {
        private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
        public final int count;
        public final float m1;
        public final float m5;
        public final float m15;
        public final int entityActive;
        public final int entityTotal;

        public CpuUsage() {
            String avg = Util.loadString("/proc/loadavg", "0.0 0.0 0.0 0/0 0");
            String[] avgs = avg.split(" ");
            String[] ents = avgs[3].split("/");
            this.count = CPU_COUNT;
            this.m1 = Float.parseFloat(avgs[0]);
            this.m5 = Float.parseFloat(avgs[1]);
            this.m15 = Float.parseFloat(avgs[2]);
            this.entityActive = Integer.parseInt(ents[0]);
            this.entityTotal = Integer.parseInt(ents[1]);
        }
    }
}

