/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class ReflectionUtil {
    private static WeakHashMap<Class<?>, Map<Class<?>, Field[]>> cache = new WeakHashMap();

    private ReflectionUtil() {
    }

    public static Map<Class<?>, Field[]> getAllFields(Class<?> clazz) {
        Map<Class<?>, Field[]> fields = cache.get(clazz);
        if (fields == null) {
            fields = new HashMap();
            fields.put(clazz, clazz.getDeclaredFields());
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                fields.putAll(ReflectionUtil.getAllFields(superClass));
            }
            cache.put(clazz, fields);
        }
        return fields;
    }

    public static Map<Class<?>, Field[]> keepAssignableTo(Map<Class<?>, Field[]> fields, Class<?> target) {
        HashMap result = new HashMap();
        for (Map.Entry<Class<?>, Field[]> entry : fields.entrySet()) {
            ArrayList<Field> toKeep = new ArrayList<Field>();
            for (Field field : entry.getValue()) {
                if (!target.isAssignableFrom(field.getType())) continue;
                toKeep.add(field);
            }
            if (toKeep.isEmpty()) continue;
            result.put(entry.getKey(), toKeep.toArray(new Field[0]));
        }
        return result;
    }

    public static Field[] keepAssignableFrom(Field[] fields, Class<?> target, boolean keepFinal) {
        ArrayList<Field> toKeep = new ArrayList<Field>();
        for (Field field : fields) {
            if (!field.getType().isAssignableFrom(target) || !keepFinal && Modifier.isFinal(field.getModifiers())) continue;
            toKeep.add(field);
        }
        return toKeep.toArray(new Field[0]);
    }

    public static Map<Class<?>, Field[]> keepAssignableFrom(Map<Class<?>, Field[]> fields, Class<?> target, boolean keepFinal) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<Class<?>, Field[]> classFields : fields.entrySet()) {
            result.put(classFields.getKey(), ReflectionUtil.keepAssignableFrom(classFields.getValue(), target, keepFinal));
        }
        return result;
    }

    public static Field[] removeFieldsOfClass(Field[] fields, Class<?> toRemove) {
        ArrayList<Field> toKeep = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (field.getType().equals(toRemove)) continue;
            toKeep.add(field);
        }
        return toKeep.toArray(new Field[0]);
    }

    public static Map<Class<?>, Field[]> removeFieldsOfClass(Map<Class<?>, Field[]> fields, Class<?> toRemove) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<Class<?>, Field[]> classFields : fields.entrySet()) {
            result.put(classFields.getKey(), ReflectionUtil.removeFieldsOfClass(classFields.getValue(), toRemove));
        }
        return result;
    }

    public static int checkEnclosing(Class<?> left, Class<?> right) {
        if (ReflectionUtil.isEnclosedBy(right, left)) {
            return -1;
        }
        if (ReflectionUtil.isEnclosedBy(left, right)) {
            return 1;
        }
        return 0;
    }

    public static boolean isEnclosedBy(Class<?> inner, Class<?> outer) {
        Class<?> enclosing;
        Class<?> current = inner;
        do {
            if (outer.equals(enclosing = current.getEnclosingClass())) {
                return true;
            }
            current = enclosing;
        } while (enclosing != null);
        return false;
    }
}

