/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class DoubleListIterator
implements ListIterator<Double> {
    private final double[] array;
    private int index;

    public DoubleListIterator(double[] array) {
        this.array = array;
        this.index = -1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.length - 1;
    }

    @Override
    public Double next() {
        if (this.hasNext()) {
            return this.array[++this.index];
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= 0;
    }

    @Override
    public Double previous() {
        if (this.index == 0) {
            return this.array[this.index--];
        }
        if (this.hasPrevious()) {
            return this.array[--this.index];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove an element of a primitive array!");
    }

    @Override
    public void set(Double val) {
        this.array[this.index] = val;
    }

    @Override
    public void add(Double val) {
        throw new UnsupportedOperationException("Can't add an element to a primitive array!");
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

