/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import com.sb.factorium.FieldMod;
import com.sb.factorium.MethodMod;
import com.sb.factorium.Modifier;
import java.util.ArrayList;
import java.util.List;

public class MixedMultiMod
implements Modifier {
    private static final int NOT_A_METHOD = -1;
    protected Modifier[] modifiers;

    public MixedMultiMod(Object ... args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("A MixedMultiMod must have at least two arguments (a key and a value)");
        }
        this.init(args);
    }

    private void init(Object[] args) {
        ArrayList<Modifier> accumulator = new ArrayList<Modifier>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof String) {
                i = this.analyzeArgument(args, i, accumulator);
                continue;
            }
            throw new IllegalArgumentException("Argument #" + i + " should be a string indicating a field or a method!");
        }
        this.modifiers = accumulator.toArray(new Modifier[0]);
    }

    private int analyzeArgument(Object[] args, int i, List<Modifier> accumulator) {
        String name = (String)args[i];
        int nArguments = this.countArguments(name);
        if (nArguments == -1) {
            if (i + 1 >= args.length) {
                throw new IndexOutOfBoundsException("Argument #" + i + " is a field reference, but it is the last argument!");
            }
            accumulator.add(new FieldMod(name, args[++i]));
        } else {
            name = name.substring(0, name.lastIndexOf("("));
            int STOP_AT = i + nArguments;
            if (STOP_AT >= args.length) {
                throw new IndexOutOfBoundsException("Argument #" + i + " references a method that would take " + nArguments + " arguments, but not enough arguments were provided!");
            }
            ArrayList<Object> arguments = new ArrayList<Object>(nArguments);
            while (i < STOP_AT) {
                arguments.add(args[++i]);
            }
            accumulator.add(new MethodMod(name, arguments.toArray()));
        }
        return i;
    }

    protected int countArguments(String str) {
        if (str.endsWith(")")) {
            String nArguments = str.substring(str.lastIndexOf("(") + 1, str.length() - 1);
            return nArguments.length() == 0 ? 1 : Integer.parseInt(nArguments);
        }
        return -1;
    }

    @Override
    public void apply(Object target) {
        for (Modifier modifier : this.modifiers) {
            modifier.apply(target);
        }
    }
}

