/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import com.sb.factorium.Generator;
import com.sb.factorium.GeneratorComparator;
import com.sb.factorium.GeneratorInfo;
import com.sb.factorium.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;

public final class MetaGeneratorUtil {
    private static WeakHashMap<Generator<?>, Class<?>> returnTypesCache = new WeakHashMap();
    private static boolean tolerateUnknownAutoPersist = true;

    private MetaGeneratorUtil() {
    }

    public static boolean tolerateUnknownAutoPersist() {
        return tolerateUnknownAutoPersist;
    }

    public static void tolerateUnknownAutoPersist(boolean tolerateUnknownAutoPersist) {
        MetaGeneratorUtil.tolerateUnknownAutoPersist = tolerateUnknownAutoPersist;
    }

    public static String suggestName(Generator<?> generator) {
        Class<?> clazz = generator.getClass();
        GeneratorInfo meta = clazz.getAnnotation(GeneratorInfo.class);
        if (meta != null) {
            return meta.name();
        }
        return clazz.getName();
    }

    public static Class<?> returnType(Generator<?> generator) {
        Class<?> result = returnTypesCache.get(generator);
        if (result == null) {
            Class<?> clazz = generator.getClass();
            GeneratorInfo meta = clazz.getAnnotation(GeneratorInfo.class);
            if (meta != null && meta.target() != null) {
                result = meta.target();
            } else if (meta == null && tolerateUnknownAutoPersist || meta != null && !meta.autoPersist()) {
                result = generator.generate(new Modifier[0]).getClass();
            } else {
                throw new IllegalArgumentException("The given generator " + MetaGeneratorUtil.suggestName(generator) + " does not specify a return type and " + (meta == null ? "might " : "") + "auto-persists!");
            }
            returnTypesCache.put(generator, result);
        }
        return result;
    }

    public static Map<Class<?>, SortedSet<Generator<?>>> hierarchise(Collection<Generator<?>> generators) {
        HashMap hierarchy = new HashMap();
        for (Generator<?> generator : generators) {
            for (Class clazz : ClassUtils.hierarchy(MetaGeneratorUtil.returnType(generator), (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
                TreeSet generatorsForClass = (TreeSet)hierarchy.get(clazz);
                if (generatorsForClass == null) {
                    generatorsForClass = new TreeSet(new GeneratorComparator(clazz));
                    hierarchy.put(clazz, generatorsForClass);
                }
                generatorsForClass.add(generator);
            }
        }
        return hierarchy;
    }

    public static boolean allAssignableTo(Collection<Generator<?>> generators, Class<?> target) {
        for (Generator<?> generator : generators) {
            if (target.isAssignableFrom(MetaGeneratorUtil.returnType(generator))) continue;
            return false;
        }
        return true;
    }
}

