/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import com.sb.factorium.ClassDistanceComparator;
import com.sb.factorium.Generator;
import com.sb.factorium.GeneratorInfo;
import com.sb.factorium.MetaGeneratorUtil;
import com.sb.factorium.reflection.ReflectionUtil;
import java.util.Comparator;

public class GeneratorComparator
implements Comparator<Generator<?>> {
    private final ClassDistanceComparator comparator;
    private final Class<?> target;

    public GeneratorComparator(Class<?> target) {
        this.comparator = new ClassDistanceComparator(target, false);
        this.target = target;
    }

    @Override
    public int compare(Generator<?> left, Generator<?> right) {
        boolean isRightDefault;
        GeneratorInfo leftInfo = left.getClass().getAnnotation(GeneratorInfo.class);
        boolean isLeftDefault = leftInfo != null && leftInfo.isDefault() && this.target.equals(leftInfo.target());
        GeneratorInfo rightInfo = right.getClass().getAnnotation(GeneratorInfo.class);
        boolean bl = isRightDefault = rightInfo != null && rightInfo.isDefault() && this.target.equals(rightInfo.target());
        if (isLeftDefault == isRightDefault) {
            int enclosingOne;
            if (!isLeftDefault && (enclosingOne = ReflectionUtil.checkEnclosing(left.getClass(), right.getClass())) != 0) {
                return enclosingOne;
            }
            return this.comparator.compare(MetaGeneratorUtil.returnType(left), MetaGeneratorUtil.returnType(right));
        }
        if (isLeftDefault) {
            return -1;
        }
        return 1;
    }
}

