/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import com.sb.factorium.Modifier;
import com.sb.factorium.iterators.IteratorUtil;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;

public class FieldMod
implements Modifier {
    public static final char ALL_SYMBOL = '*';
    private static final int ALL_CHILDREN = -1;
    private final String[] nestedFields;
    private final Object value;

    public FieldMod(String field, Object value) {
        this.value = value;
        this.nestedFields = field.split("\\.");
    }

    private boolean isIndexed(String pathSegment) {
        return pathSegment.endsWith("]");
    }

    private int extractIndex(String indexedField) {
        String indexer = indexedField.substring(indexedField.indexOf(91) + 1, indexedField.length() - 1);
        if (indexer.length() == 0) {
            throw new IllegalArgumentException("Empty indexer in " + indexedField);
        }
        if (indexer.length() == 1 && indexer.charAt(0) == '*') {
            return -1;
        }
        return Integer.parseInt(indexer);
    }

    private void recursiveApply(Object target, int startAt) throws NoSuchFieldException, IllegalAccessException {
        String field = this.nestedFields[startAt];
        if (startAt != this.nestedFields.length - 1) {
            for (int i = startAt; i < this.nestedFields.length - 1; ++i) {
                field = this.nestedFields[i];
                if (!this.isIndexed(field)) {
                    target = this.getTarget(target, field);
                    continue;
                }
                if ((target = this.indexedOperation(target, field, i)) != null) continue;
                return;
            }
            field = this.nestedFields[this.nestedFields.length - 1];
        }
        if (this.isIndexed(field)) {
            this.indexedOperation(target, field, startAt);
        } else {
            this.replace(target, field);
        }
    }

    private Object indexedOperation(Object target, String field, int indexOfField) throws NoSuchFieldException, IllegalAccessException {
        target = this.getTarget(target, field.substring(0, field.indexOf(91)));
        int targetIndex = this.extractIndex(field);
        OperationType opType = this.operationType(indexOfField);
        if (opType == OperationType.REPLACE) {
            this.indexedReplace(target, targetIndex);
        } else {
            Iterator<?> iterator = IteratorUtil.toIterator(target);
            if (targetIndex == -1) {
                while (iterator.hasNext()) {
                    this.recursiveApply(iterator.next(), indexOfField + 1);
                }
                return null;
            }
            for (int j = 0; j < targetIndex; ++j) {
                iterator.next();
            }
            target = iterator.next();
        }
        return target;
    }

    private void replace(Object target, String field) throws NoSuchFieldException, IllegalAccessException {
        Field toChange = target.getClass().getDeclaredField(field);
        boolean originalAccess = toChange.isAccessible();
        toChange.setAccessible(true);
        toChange.set(target, this.value);
        toChange.setAccessible(originalAccess);
    }

    private void indexedReplace(Object target, int index) {
        ListIterator<?> listIterator = IteratorUtil.toListIterator(target);
        if (index == -1) {
            while (listIterator.hasNext()) {
                listIterator.next();
                listIterator.set(this.value);
            }
        } else {
            while (listIterator.previousIndex() != index) {
                listIterator.next();
            }
            listIterator.set(this.value);
        }
    }

    private Object getTarget(Object target, String field) throws NoSuchFieldException, IllegalAccessException {
        Field targetField = target.getClass().getDeclaredField(field);
        boolean originalAccess = targetField.isAccessible();
        targetField.setAccessible(true);
        target = targetField.get(target);
        targetField.setAccessible(originalAccess);
        return target;
    }

    @Override
    public void apply(Object target) {
        try {
            this.recursiveApply(target, 0);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Type " + target.getClass().getName() + " does not contain the field: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String fullTarget() {
        return StringUtils.joinWith((String)".", (Object[])this.nestedFields);
    }

    public Object getValue() {
        return this.value;
    }

    private OperationType operationType(int index) {
        return index == this.nestedFields.length - 1 ? OperationType.REPLACE : OperationType.SET_SUBCOMPONENT;
    }

    private static enum OperationType {
        REPLACE,
        SET_SUBCOMPONENT;

    }
}

