/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import com.sb.factorium.Factory;
import com.sb.factorium.FactoryMaker;
import com.sb.factorium.Generator;
import com.sb.factorium.MetaGeneratorUtil;
import com.sb.factorium.reflection.DefaultSurrogate;
import com.sb.factorium.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang3.tuple.Pair;

public class FactoryProvider<F extends Factory<String, ?>> {
    public static final String DEFAULT_KEY = "default";
    private Map<Class<?>, F> factories;

    public FactoryProvider(Map<Class<?>, F> factories) {
        this.factories = factories;
    }

    public Map<Class<?>, F> getFactories() {
        return this.factories;
    }

    public <T> Factory<String, T> factory(Class<T> clazz) {
        return (Factory)this.factories.get(clazz);
    }

    public static <F extends Factory<String, ?>> FactoryProvider<F> make(Collection<Generator<?>> generators, DefaultKey keyPolicy, FactoryMaker<F> factoryMaker, boolean replaceInnerReferences) throws IllegalAccessException {
        Map<Class<?>, SortedSet<Generator<?>>> types = MetaGeneratorUtil.hierarchise(generators);
        HashMap factories = new HashMap();
        for (Map.Entry<Class<?>, SortedSet<Generator<?>>> generatorsOfType : types.entrySet()) {
            Generator<?> defaultGenerator = generatorsOfType.getValue().first();
            String defaultKey = FactoryProvider.computeDefaultKey(keyPolicy, defaultGenerator);
            F factory = factoryMaker.factorise(generatorsOfType.getValue(), generatorsOfType.getKey(), Pair.of((Object)defaultKey, defaultGenerator));
            factories.put(generatorsOfType.getKey(), factory);
        }
        if (replaceInnerReferences) {
            FactoryProvider.replaceInnerReferences(generators, factories);
        }
        return new FactoryProvider(factories);
    }

    public static void replaceInnerReferences(Collection<Generator<?>> generators, Map<Class<?>, ? extends Factory<?, ?>> factories) throws IllegalAccessException {
        for (Generator<?> generator : generators) {
            Map<Class<?>, Field[]> fields = ReflectionUtil.getAllFields(generator.getClass());
            Map<Class<?>, Field[]> innerGenerators = ReflectionUtil.keepAssignableFrom(fields, Generator.class, false);
            innerGenerators = ReflectionUtil.removeFieldsOfClass(innerGenerators, Object.class);
            for (Field[] classFields : innerGenerators.values()) {
                for (Field field : classFields) {
                    FactoryProvider.replaceContent(factories, generator, field);
                }
            }
        }
    }

    private static void replaceContent(Map<Class<?>, ? extends Factory<?, ?>> factories, Generator<?> generator, Field field) throws IllegalAccessException {
        boolean originalAccessibility = field.isAccessible();
        field.setAccessible(true);
        Generator innerGenerator = (Generator)field.get(generator);
        Factory<?, ?> factory = factories.get(MetaGeneratorUtil.returnType(innerGenerator));
        if (factory != null) {
            for (Map.Entry<?, Generator<?>> candidate : factory.getGenerators().entrySet()) {
                if (candidate.getValue() != innerGenerator) continue;
                field.set(generator, new DefaultSurrogate(factory, candidate.getKey()));
            }
        }
        field.setAccessible(originalAccessibility);
    }

    static String computeDefaultKey(DefaultKey keyPolicy, Generator<?> defaultGenerator) {
        String result = null;
        switch (keyPolicy) {
            case DEFAULT_KEY: {
                result = DEFAULT_KEY;
                break;
            }
            case FIRST_GENERATOR: {
                result = MetaGeneratorUtil.suggestName(defaultGenerator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized keyPolicy! " + keyPolicy);
            }
        }
        return result;
    }

    public static enum DefaultKey {
        DEFAULT_KEY,
        FIRST_GENERATOR;

    }
}

