/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import java.util.Comparator;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;

class ClassDistanceComparator
implements Comparator<Class<?>> {
    private Class<?> target;
    private final boolean allowEquals;
    private final WeakHashMap<Class<?>, Integer> distancesCache;

    public ClassDistanceComparator(Class<?> target, boolean allowEquals) {
        this.target = target;
        this.allowEquals = allowEquals;
        this.distancesCache = new WeakHashMap();
    }

    @Override
    public int compare(Class<?> left, Class<?> right) {
        int result = Integer.compare(this.distance(left), this.distance(right));
        if (result == 0 && !this.allowEquals) {
            result = left.getName().compareTo(right.getName());
        }
        return result;
    }

    public int distance(Class<?> clazz) {
        Integer distance = this.distancesCache.get(clazz);
        if (distance == null) {
            int dist = 0;
            ClassUtils.Interfaces interfaceChecking = this.target.isInterface() ? ClassUtils.Interfaces.INCLUDE : ClassUtils.Interfaces.EXCLUDE;
            Iterator hierarchyIt = ClassUtils.hierarchy(clazz, (ClassUtils.Interfaces)interfaceChecking).iterator();
            while (hierarchyIt.hasNext()) {
                ++dist;
                Class superClass = (Class)hierarchyIt.next();
                if (!superClass.equals(this.target)) continue;
                break;
            }
            if (!hierarchyIt.hasNext() && this.target != Object.class) {
                throw new IllegalArgumentException(clazz.getName() + " is not assignable to " + this.target.getName());
            }
            distance = dist;
            this.distancesCache.put(clazz, distance);
        }
        return distance;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public boolean isAllowEquals() {
        return this.allowEquals;
    }
}

