/*
 * Decompiled with CFR 0.152.
 */
package com.sb.factorium;

import com.sb.factorium.Factory;
import com.sb.factorium.Generator;
import com.sb.factorium.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class BaseFactory<K, T>
implements Factory<K, T> {
    private final Class<T> generatedType;
    protected K defaultKey;
    protected Map<K, Generator<T>> generators;

    protected BaseFactory(Class<T> generatedType, K defaultKey, Map<K, Generator<T>> generators) {
        if (!generators.containsKey(defaultKey)) {
            throw new IllegalArgumentException("The default key is not present in the generators map.");
        }
        this.generatedType = generatedType;
        this.defaultKey = defaultKey;
        this.generators = generators;
    }

    @Override
    public Map<K, Generator<T>> getGenerators() {
        return this.generators;
    }

    @Override
    public T generate(Modifier ... modifiers) {
        return this.generate(this.defaultKey, modifiers);
    }

    @Override
    public List<T> generate(int nItems, Modifier ... modifiers) {
        return this.generate(this.defaultKey, nItems, modifiers);
    }

    @Override
    public T generate(K generatorKey, Modifier ... modifiers) {
        Generator<T> generator = this.getGenerator(generatorKey);
        T result = generator.generate(modifiers);
        this.decorate(result, modifiers);
        return result;
    }

    @Override
    public List<T> generate(K generatorKey, int nItems, Modifier ... modifiers) {
        Generator<T> generator = this.getGenerator(generatorKey);
        List<T> results = generator.generate(nItems, modifiers);
        this.decorate((Collection<T>)results, modifiers);
        return results;
    }

    protected Generator<T> getGenerator(K generatorKey) {
        Generator<T> generator = this.generators.get(generatorKey);
        if (generator == null) {
            throw new NoSuchElementException("No registered generator with the key " + generatorKey);
        }
        return generator;
    }

    protected abstract void decorate(T var1, Modifier[] var2);

    protected void decorate(Collection<T> newItems, Modifier[] modifiers) {
        for (T obj : newItems) {
            this.decorate(obj, modifiers);
        }
    }

    @Override
    public K getDefaultKey() {
        return this.defaultKey;
    }

    public Class<T> getGeneratedType() {
        return this.generatedType;
    }
}

