package com.sb.factorium;

import java.util.List;
import java.util.Map;

/**
 * Describes a factory grouping many generators with the same output type.
 * Generator methods that do not specify the generator to use should use the factory's default generator.
 * @param <K> the key type used for this factory's map.
 * @param <T> the type generated by this factory.
 */
public interface Factory<K, T> extends Generator<T> {
    /**
     * Return the key to the default generator.
     * @return the key to the default generator.
     */
    K getDefaultKey();

    /**
     * Return all the registered generators.
     * @return an unmodifiable map of the registered generators.
     */
    Map<K, Generator<T>> getGenerators();

    /**
     * Generate an item
     * @param generatorKey the key to the generator to use
     * @param  modifiers the modifiers to apply on the items/
     * @return one object of the generator's target type.
     * @throws java.util.NoSuchElementException if no generator is found with that key.
     */
    T generate(K generatorKey, Modifier... modifiers);

    /**
     * Generate nItems
     * @param generatorKey the key to the generator to use
     * @param nItems the number of items to generate.
     * @param modifiers the modifiers to apply on the items.
     * @return a list containing all the generated items. If nItems is zero, return an empty (modifiable) list.
     * @throws java.util.NoSuchElementException if no generator is found with that key.
     */
    List<T> generate(K generatorKey, int nItems, Modifier... modifiers);
}
