/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import systems.fehn.boot.starter.hashids.Hashids;
import systems.fehn.boot.starter.hashids.HashidsProvider;
import systems.fehn.boot.starter.hashids.jackson.TypeInformation;

public class HashidsSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private final TypeInformation typeInformation;
    private final HashidsProvider provider;
    private final Hashids annotation;

    @Autowired
    public HashidsSerializer(HashidsProvider provider) {
        super(Object.class);
        this.typeInformation = null;
        this.provider = provider;
        this.annotation = null;
    }

    private HashidsSerializer(TypeInformation typeInformation, HashidsProvider provider, Hashids annotation) {
        super(Object.class);
        this.typeInformation = typeInformation;
        this.provider = provider;
        this.annotation = annotation;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        TypeInformation typeInformation;
        Hashids annotation = (Hashids)property.getAnnotation(Hashids.class);
        if (annotation != null && (typeInformation = TypeInformation.of(property.getType())) != null) {
            return new HashidsSerializer(typeInformation, this.provider, annotation);
        }
        return null;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        assert (this.typeInformation != null);
        assert (this.annotation != null);
        org.hashids.Hashids hashids = this.provider.getFromAnnotation(this.annotation);
        String encoded = HashidsSerializer.encode(value, hashids, this.typeInformation);
        gen.writeString(encoded);
    }

    public static String encode(Object value, org.hashids.Hashids hashids, TypeInformation typeInformation) {
        if (typeInformation.isArray()) {
            long[] realValues = typeInformation.isBoxed() ? (typeInformation.isLong() ? Stream.of((Long[])value).mapToLong(Long::longValue).toArray() : Stream.of((Integer[])value).mapToLong(Integer::longValue).toArray()) : (typeInformation.isLong() ? (long[])value : IntStream.of((int[])value).mapToLong(Long::valueOf).toArray());
            return hashids.encode(realValues);
        }
        long realValue = typeInformation.isLong() ? (Long)value : (long)((Integer)value).intValue();
        return hashids.encode(new long[]{realValue});
    }
}

