/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids;

import java.util.LinkedHashMap;
import java.util.Map;
import systems.fehn.boot.starter.hashids.Hashids;
import systems.fehn.boot.starter.hashids.HashidsProperties;

public class HashidsProvider {
    private final Map<HashidsProperties, org.hashids.Hashids> lruCache = new LinkedHashMap<HashidsProperties, org.hashids.Hashids>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashidsProperties, org.hashids.Hashids> eldest) {
            return this.size() > 10;
        }
    };
    private final HashidsProperties properties;

    public HashidsProvider(HashidsProperties properties) {
        this.properties = properties;
    }

    public org.hashids.Hashids getHashids(String salt, int minHashLength, String alphabet) {
        HashidsProperties key = new HashidsProperties(salt, minHashLength, alphabet);
        org.hashids.Hashids hashids = this.lruCache.get(key);
        if (hashids != null) {
            return hashids;
        }
        hashids = alphabet == null ? new org.hashids.Hashids(salt, minHashLength) : new org.hashids.Hashids(salt, minHashLength, alphabet);
        this.lruCache.put(key, hashids);
        return hashids;
    }

    public org.hashids.Hashids getFromAnnotation(Hashids annotation) {
        String salt = annotation.salt().equals("salt_from_properties") ? this.properties.getSalt() : annotation.salt();
        int minHashLength = annotation.minHashLength() == -1 ? this.properties.getMinHashLength() : annotation.minHashLength();
        String alphabet = annotation.alphabet().equals("alphabet_from_properties") ? this.properties.getAlphabet() : annotation.alphabet();
        return this.getHashids(salt, minHashLength, alphabet);
    }
}

