/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids;

import java.util.HashSet;
import java.util.Set;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import systems.fehn.boot.starter.hashids.Hashids;
import systems.fehn.boot.starter.hashids.HashidsProvider;
import systems.fehn.boot.starter.hashids.jackson.HashidsDeserializer;
import systems.fehn.boot.starter.hashids.jackson.HashidsSerializer;
import systems.fehn.boot.starter.hashids.jackson.TypeInformation;

public class HashidsAnnotationFormatterFactory
implements AnnotationFormatterFactory<Hashids> {
    private final HashidsProvider provider;

    public HashidsAnnotationFormatterFactory(HashidsProvider provider) {
        this.provider = provider;
    }

    public Set<Class<?>> getFieldTypes() {
        HashSet set = new HashSet();
        set.add(Integer.TYPE);
        set.add(Integer.class);
        set.add(Long.TYPE);
        set.add(Long.class);
        set.add(int[].class);
        set.add(Integer[].class);
        set.add(long[].class);
        set.add(Long[].class);
        return set;
    }

    public Printer<?> getPrinter(Hashids annotation, Class<?> fieldType) {
        org.hashids.Hashids hashids = this.provider.getFromAnnotation(annotation);
        TypeInformation typeInformation = HashidsAnnotationFormatterFactory.getTypeInformation(fieldType);
        return (object, locale) -> HashidsSerializer.encode(object, hashids, typeInformation);
    }

    public Parser<?> getParser(Hashids annotation, Class<?> fieldType) {
        org.hashids.Hashids hashids = this.provider.getFromAnnotation(annotation);
        TypeInformation typeInformation = HashidsAnnotationFormatterFactory.getTypeInformation(fieldType);
        return (text, locale) -> HashidsDeserializer.decode(text, hashids, typeInformation);
    }

    private static TypeInformation getTypeInformation(Class<?> fieldType) {
        if (fieldType.isArray()) {
            return new TypeInformation(true, fieldType == Integer[].class || fieldType == Long[].class, fieldType == long[].class || fieldType == Long[].class);
        }
        return new TypeInformation(false, fieldType == Integer.class || fieldType == Long.class, fieldType == Long.TYPE || fieldType == Long.class);
    }
}

