/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids.jackson;

import com.fasterxml.jackson.databind.JavaType;

public class TypeInformation {
    private final boolean isArray;
    private final boolean isBoxed;
    private final boolean isLong;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeInformation of(JavaType type) {
        boolean isLong;
        boolean isBoxed;
        boolean isArray;
        if (type.isArrayType()) {
            isArray = true;
            boolean bl = isBoxed = !type.getContentType().isPrimitive();
            if (TypeInformation.isIntType(type.getContentType())) {
                isLong = false;
                return new TypeInformation(isArray, isBoxed, isLong);
            } else {
                if (!TypeInformation.isLongType(type.getContentType())) return null;
                isLong = true;
            }
            return new TypeInformation(isArray, isBoxed, isLong);
        } else {
            isArray = false;
            boolean bl = isBoxed = !type.isPrimitive();
            if (TypeInformation.isIntType(type)) {
                isLong = false;
                return new TypeInformation(isArray, isBoxed, isLong);
            } else {
                if (!TypeInformation.isLongType(type)) return null;
                isLong = true;
            }
        }
        return new TypeInformation(isArray, isBoxed, isLong);
    }

    private static boolean isIntType(JavaType type) {
        return type.hasRawClass(Integer.TYPE) || type.hasRawClass(Integer.class);
    }

    private static boolean isLongType(JavaType type) {
        return type.hasRawClass(Long.TYPE) || type.hasRawClass(Long.class);
    }

    public TypeInformation(boolean isArray, boolean isBoxed, boolean isLong) {
        this.isArray = isArray;
        this.isBoxed = isBoxed;
        this.isLong = isLong;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isBoxed() {
        return this.isBoxed;
    }

    public boolean isLong() {
        return this.isLong;
    }
}

