/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids.jackson;

import systems.fehn.boot.starter.hashids.HashidsProperties;
import systems.fehn.boot.starter.hashids.HashidsProvider;
import systems.fehn.boot.starter.hashids.jackson.Hashids;

public class HashidsJacksonProvider {
    private final HashidsProperties properties;
    private final HashidsProvider provider;

    public HashidsJacksonProvider(HashidsProperties properties, HashidsProvider provider) {
        this.properties = properties;
        this.provider = provider;
    }

    public org.hashids.Hashids getFromAnnotation(Hashids annotation) {
        String salt = annotation.salt().equals("salt_from_properties") ? this.properties.getSalt() : annotation.salt();
        int minHashLength = annotation.minHashLength() == -1 ? this.properties.getMinHashLength() : annotation.minHashLength();
        String alphabet = annotation.alphabet().equals("alphabet_from_properties") ? this.properties.getAlphabet() : annotation.alphabet();
        return this.provider.getHashids(salt, minHashLength, alphabet);
    }
}

