/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.util.stream.LongStream;
import org.springframework.beans.factory.annotation.Autowired;
import systems.fehn.boot.starter.hashids.jackson.Hashids;
import systems.fehn.boot.starter.hashids.jackson.HashidsJacksonProvider;
import systems.fehn.boot.starter.hashids.jackson.TypeInformation;

public class HashidsDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    private final TypeInformation typeInformation;
    private final HashidsJacksonProvider provider;
    private final Hashids annotation;

    @Autowired
    public HashidsDeserializer(HashidsJacksonProvider provider) {
        super(Object.class);
        this.provider = provider;
        this.typeInformation = null;
        this.annotation = null;
    }

    private HashidsDeserializer(TypeInformation typeInformation, HashidsJacksonProvider provider, Hashids annotation) {
        super(Object.class);
        this.typeInformation = typeInformation;
        this.provider = provider;
        this.annotation = annotation;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        TypeInformation typeInformation;
        Hashids annotation = (Hashids)property.getAnnotation(Hashids.class);
        if (annotation != null && (typeInformation = TypeInformation.of(property.getType())) != null) {
            return new HashidsDeserializer(typeInformation, this.provider, annotation);
        }
        return null;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.currentToken() == JsonToken.VALUE_STRING) {
            assert (this.typeInformation != null);
            assert (this.annotation != null);
            org.hashids.Hashids hashids = this.provider.getFromAnnotation(this.annotation);
            String encoded = p.getValueAsString();
            long[] decoded = hashids.decode(encoded);
            if (this.typeInformation.isArray()) {
                if (this.typeInformation.isBoxed()) {
                    if (this.typeInformation.isLong()) {
                        return LongStream.of(decoded).boxed().toArray(Long[]::new);
                    }
                    return LongStream.of(decoded).mapToInt(l -> (int)l).boxed().toArray(Integer[]::new);
                }
                if (this.typeInformation.isLong()) {
                    return decoded;
                }
                return LongStream.of(decoded).mapToInt(l -> (int)l).toArray();
            }
            if (this.typeInformation.isLong()) {
                return decoded[0];
            }
            return (int)decoded[0];
        }
        return null;
    }
}

