/*
 * Decompiled with CFR 0.152.
 */
package systems.fehn.boot.starter.hashids;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hashids.Hashids;
import systems.fehn.boot.starter.hashids.HashidsProperties;

public class HashidsProvider {
    private final Map<HashidsProperties, Hashids> lruCache = new LinkedHashMap<HashidsProperties, Hashids>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashidsProperties, Hashids> eldest) {
            return this.size() > 10;
        }
    };

    public Hashids getHashids(String salt, int minHashLength, String alphabet) {
        HashidsProperties key = new HashidsProperties(salt, minHashLength, alphabet);
        Hashids hashids = this.lruCache.get(key);
        if (hashids != null) {
            return hashids;
        }
        hashids = alphabet == null ? new Hashids(salt, minHashLength) : new Hashids(salt, minHashLength, alphabet);
        this.lruCache.put(key, hashids);
        return hashids;
    }
}

