/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.accesscontrol;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

class AnonymousAccessFilter {
    private List<String> prefixesRead;
    private List<String> prefixesWrite;

    AnonymousAccessFilter(String settingRead, String settingWrite) {
        this.prefixesRead = this.initPrefixes(settingRead);
        this.prefixesWrite = this.initPrefixes(settingWrite);
    }

    boolean isAnonymousAccessAllowed(HttpServletRequest request) {
        return request.getMethod().equals("GET") ? this.prefixMatch(request, this.prefixesRead) : this.prefixMatch(request, this.prefixesWrite);
    }

    String dumpReadSetting() {
        return this.dumpSetting(this.prefixesRead);
    }

    String dumpWriteSetting() {
        return this.dumpSetting(this.prefixesWrite);
    }

    private List<String> initPrefixes(String setting) {
        if (setting.equals("ALL")) {
            return null;
        }
        if (setting.equals("NONE")) {
            return new ArrayList<String>();
        }
        String[] p = setting.split(",\\s*");
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < p.length; ++i) {
            prefixes.add(p[i]);
        }
        return prefixes;
    }

    private boolean prefixMatch(HttpServletRequest request, List<String> prefixes) {
        if (prefixes == null) {
            return true;
        }
        for (String prefix : prefixes) {
            if (!request.getRequestURI().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private String dumpSetting(List<String> prefixes) {
        if (prefixes == null) {
            return "ALL";
        }
        if (prefixes.isEmpty()) {
            return "NONE";
        }
        return prefixes.toString();
    }
}

