/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.favorite.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.favorite.controller.FavoriteResponse;
import systems.dennis.shared.favorite.exception.FavoriteException;
import systems.dennis.shared.favorite.form.FavoriteItemForm;
import systems.dennis.shared.favorite.model.FavoriteItemModel;
import systems.dennis.shared.favorite.service.FavoriteItemService;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.mongo.controller.AddItemController;
import systems.dennis.shared.mongo.controller.DeleteItemController;
import systems.dennis.shared.mongo.controller.ListItemController;
import systems.dennis.shared.mongo.service.StringIdEntity;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

@RestController
@RequestMapping(value={"/api/v2/shared/favorite"})
@WebFormsSupport(value=FavoriteItemService.class)
@CrossOrigin
@Secured
public class FavoriteItemController<ID_TYPE extends Serializable>
extends ApplicationContext
implements AddItemController<FavoriteItemModel, FavoriteItemForm>,
ListItemController<FavoriteItemModel, FavoriteItemForm>,
DeleteItemController<FavoriteItemModel> {
    public FavoriteItemController(WebContext context) {
        super(context);
    }

    @GetMapping(value={"/enabled"})
    @ResponseBody
    @WithRole
    public ResponseEntity<FavoriteResponse> enabled() {
        return ResponseEntity.ok((Object)new FavoriteResponse(this.getService().getIsFavoriteEnabled(), ""));
    }

    @GetMapping(value={"/byName"})
    @ResponseBody
    @WithRole
    public ResponseEntity<FavoriteResponse> byName(@RequestParam(value="name") String name) {
        return ResponseEntity.ok((Object)new FavoriteResponse(this.getService().getIsFavoriteEnabled(), this.getService().findBySearchName(name)));
    }

    @PostMapping(value={"/is_favorite"})
    @ResponseBody
    @WithRole
    public ResponseEntity<FavoriteResponse> isFavorite(@RequestBody FavoriteItemForm form) {
        return ResponseEntity.ok((Object)new FavoriteResponse(this.getService().isFavoriteForObject(form), ""));
    }

    @PostMapping(value={"/delete"})
    public FavoriteResponse delete(@RequestBody FavoriteItemForm id) throws ItemNotUserException, ItemNotFoundException {
        this.getService().delete(id);
        return new FavoriteResponse(true, "");
    }

    @GetMapping(value={"/list/{type}/{searchName}"})
    @ResponseBody
    @WithRole
    public ResponseEntity<Page<Map<String, Object>>> findByType(@PathVariable String type, @PathVariable(value="searchName") String name, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        if (!this.getService().getIsFavoriteEnabled().booleanValue()) {
            return ResponseEntity.ok((Object)Page.empty());
        }
        Class searchBean = SearchEntityApi.findServiceByType((String)name);
        if (searchBean == null) {
            throw new FavoriteException("global.exception.favorite.no_search_type_present");
        }
        AbstractDataFilter specification = this.getService().getFilterImpl().eq("userDataId", (Object)this.getContext().getCurrentUser()).and(this.getService().getFilterImpl().eq("type", (Object)type));
        Page models = ((FavoriteItemService)((Object)this.getContext().getBean(FavoriteItemService.class))).find(specification, limit, page);
        List ids = models.stream().map(FavoriteItemModel::getModelId).collect(Collectors.toList());
        AbstractService bean = (AbstractService)this.getContext().getBean(searchBean);
        return ResponseEntity.ok(this.toFormPage((Page<StringIdEntity>)bean.find(this.getService().getFilterImpl().iN("id", ids), Integer.valueOf(-1), Integer.valueOf(0)), searchBean));
    }

    public Page<Map<String, Object>> toFormPage(Page<? extends StringIdEntity> page, Class<?> c) {
        DataRetrieverDescription ann = c.getAnnotation(DataRetrieverDescription.class);
        BeanCopier copier = (BeanCopier)this.getBean(BeanCopier.class);
        ArrayList<Map> data = new ArrayList<Map>();
        for (StringIdEntity entity : page.getContent()) {
            data.add(BeanCopier.values((AbstractForm)((AbstractForm)copier.copy((Object)entity, ann.form())), (AbstractEntity)entity, (WebContext.LocalWebContext)this.getContext()));
        }
        return new PageImpl(data, page.getPageable(), (long)data.size());
    }

    public FavoriteItemService getService() {
        return (FavoriteItemService)super.getService();
    }
}

