package systems.dennis.shared.utils.bean_copier;

import lombok.Data;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.utils.AddonComponent;

import java.io.Serializable;

@Data
public class ObjectDefinition<ID_TYPE extends Serializable> implements Serializable {
    private ID_TYPE key;

    private String value;
    public ObjectDefinition(AbstractEntity<ID_TYPE> entity){
        if (entity == null){
            return;
        }
        this.key = entity.getId();
        this.value = entity.asValue();

        if (entity instanceof AddonComponent){
            this.additional = ((AddonComponent) entity).getAddon();
        }
    }
    private Object additional;
}
