package systems.dennis.shared.service;

import org.springframework.data.domain.Page;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;

import java.io.Serializable;

public interface AbstractParentalService<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> extends AbstractService<DB_TYPE, ID_TYPE> {

    default String getParentField() {
        return "parent";
    }


    default long countByParent(ID_TYPE id) {

        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), findByIdOrThrow(updateId(id)));
        return getRepository().filteredCount(specification.and(getAdditionalSpecification()));
    }

    default long countByRoot(DB_TYPE x) {
        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), x);
        return count(specification.and(getAdditionalSpecification()));
    }


    default Page<DB_TYPE> findRootElements(int page, int limit) {
        AbstractDataFilter<DB_TYPE>  specification = getFilterImpl().isNull(getParentField());
        return find(specification.and(getAdditionalSpecification()),  limit, page);
    }

    default Page<DB_TYPE> findByParent(ID_TYPE parentId, int limit, int page) {
        AbstractDataFilter<DB_TYPE> specification = getFilterImpl().eq(getParentField(), findByIdOrThrow(updateId(parentId)));
        return find(specification.and(getAdditionalSpecification()),  limit, page);
    }
}
