package systems.dennis.shared.repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.stereotype.Repository;
import systems.dennis.shared.model.IDPresenter;

import java.io.Serializable;
import java.util.Optional;

@NoRepositoryBean @Repository
public interface AbstractFilterRepo<ENTITY extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> {


    /**
     * @deprecated use this method only when you are sure it is needed. Otherwise use Service analog method
     */
    @Deprecated
    Optional<ENTITY> filteredOne(AbstractDataFilter<?> one);

    /**
     * @deprecated use this method only when you are sure it is needed. Otherwise use Service analog method
     */
    @Deprecated
    Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first);

    Optional<ENTITY> filteredFirst(AbstractDataFilter<?> first, Sort sort);
    /**
     * @deprecated use this method only when you are sure it is needed. Otherwise use Service analog method
     */
    @Deprecated
    Page<ENTITY> filteredData(AbstractDataFilter<?> specification);
    Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Sort sort);
    /**
     * @deprecated use this method only when you are sure it is needed. Otherwise use Service analog method
     */
    @Deprecated
    Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable);
    Page<ENTITY> filteredData(AbstractDataFilter<?> specification, Pageable pageable, Sort sort);
    /**
     * @deprecated use this method only when you are sure it is needed. Otherwise use Service analog method
     */
    @Deprecated
    default boolean exists(AbstractDataFilter<?> specification){
        return filteredCount(specification) > 0;
    }
    /**
     * @deprecated use this method only when you are sure it is needed. Otherwise use Service analog method
     */
    @Deprecated
    long filteredCount(AbstractDataFilter<?> filter);
}
