package systems.dennis.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import lombok.Data;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.NotImplementedException;

import java.io.Serializable;

@Data
@MappedSuperclass
public abstract class IDPresenter<ID_TYPE extends Serializable> implements AbstractEntity<ID_TYPE> {

    @FormTransient
    private Boolean hidden;

    @JsonIgnore
    public  boolean isIdSet(){
        throw new NotImplementedException();
    }
    @Transient
    @Override
    @JsonIgnore
    public Boolean getHidden() {
        return hidden;
    }


}
